/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vboxwrapper;

import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.ParameterValue;
import hudson.util.VariableResolver;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VBoxParameterValue
extends ParameterValue {
    private static final long serialVersionUID = 1L;
    private final List<String> nodes = new ArrayList<String>();
    private final String nodeDelimiter;

    @DataBoundConstructor
    public VBoxParameterValue(String name, List<String> nodes, String nodeDelimiter) {
        super(name);
        if (nodes != null) {
            this.nodes.addAll(nodes);
        }
        this.nodeDelimiter = nodeDelimiter != null ? nodeDelimiter : "";
    }

    public List<String> getNodes() {
        return this.nodes;
    }

    public String getNodeDelimiter() {
        return this.nodeDelimiter;
    }

    public String getValue() {
        return StringUtils.join(this.nodes, (String)this.nodeDelimiter);
    }

    public void buildEnvVars(AbstractBuild<?, ?> build, EnvVars env) {
        env.put(this.name, this.getValue());
    }

    public VariableResolver<String> createVariableResolver(AbstractBuild<?, ?> build) {
        return new VariableResolver<String>(){

            public String resolve(String name) {
                return VBoxParameterValue.this.name.equals(name) ? VBoxParameterValue.this.getValue() : null;
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VBoxParameterValue that = (VBoxParameterValue)((Object)o);
        return this.nodeDelimiter.equals(that.nodeDelimiter) && this.nodes.equals(that.nodes);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.nodes.hashCode();
        result = 31 * result + this.nodeDelimiter.hashCode();
        return result;
    }
}

