/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vboxwrapper;

import hudson.Extension;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.SimpleParameterDefinition;
import java.util.ArrayList;
import java.util.logging.Logger;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.vboxwrapper.VBoxParameterValue;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class VBoxParameterDefinition
extends SimpleParameterDefinition {
    private static final Logger LOGGER = Logger.getLogger(VBoxParameterDefinition.class.getName());
    private static final long serialVersionUID = 1L;
    private String nodeDelimiter;

    @DataBoundConstructor
    public VBoxParameterDefinition(String name, String description, String nodeDelimiter) {
        super(name, description);
        this.nodeDelimiter = nodeDelimiter;
    }

    public String getNodeDelimiter() {
        return this.nodeDelimiter;
    }

    public ParameterValue createValue(String value) {
        LOGGER.info("In VBoxParameterDefinition::createValue: " + value);
        return new VBoxParameterValue(this.getName(), null, this.getNodeDelimiter());
    }

    public ParameterValue createValue(StaplerRequest req, JSONObject jo) {
        LOGGER.info("In VBoxParameterDefinition::createValue(2): " + jo.toString());
        ArrayList<String> nodes = new ArrayList<String>();
        Object jvalue = jo.get("nodes");
        if (jvalue instanceof String) {
            nodes.add((String)jvalue);
        } else if (jvalue instanceof JSONArray) {
            JSONArray jsonValues = (JSONArray)jvalue;
            for (int i = 0; i < jsonValues.size(); ++i) {
                nodes.add(jsonValues.getString(i));
            }
        }
        VBoxParameterValue value = new VBoxParameterValue(jo.getString("name"), nodes, this.getNodeDelimiter());
        value.setDescription(this.getDescription());
        return value;
    }

    public ParameterDefinition copyWithDefaultValue(ParameterValue defaultValueObj) {
        if (defaultValueObj instanceof VBoxParameterValue) {
            return new VBoxParameterDefinition(this.getName(), this.getDescription(), this.getNodeDelimiter());
        }
        return this;
    }

    @Extension
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public String getDisplayName() {
            return "VBox node parameter";
        }
    }
}

