/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.validating_string_parameter;

import hudson.Extension;
import hudson.model.Failure;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.plugins.validating_string_parameter.ValidatingStringParameterValue;
import hudson.util.FormValidation;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class ValidatingStringParameterDefinition
extends ParameterDefinition {
    private static final long serialVersionUID = 1L;
    private String defaultValue;
    private String regex;
    private String failedValidationMessage;
    private static Map<String, String> replacements = new HashMap<String, String>();

    @DataBoundConstructor
    public ValidatingStringParameterDefinition(String name, String defaultValue, String regex, String failedValidationMessage, String description) {
        super(name, description);
        this.defaultValue = defaultValue;
        this.regex = regex;
        this.failedValidationMessage = failedValidationMessage;
    }

    public ValidatingStringParameterDefinition(String name, String defaultValue, String regex, String failedValidationMessage) {
        this(name, defaultValue, regex, failedValidationMessage, null);
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getRegex() {
        return this.regex;
    }

    public String getJsEncodedRegex() {
        return this.jsEscape(this.regex);
    }

    public String getFailedValidationMessage() {
        return this.failedValidationMessage;
    }

    public String getJsEncodedFailedValidationMessage() {
        return this.jsEscape(this.failedValidationMessage);
    }

    private String jsEscape(String input) {
        String res = input;
        for (Map.Entry<String, String> entry : replacements.entrySet()) {
            res = res.replace(entry.getKey(), entry.getValue());
        }
        return res;
    }

    public String getRootUrl() {
        return Jenkins.getInstance().getRootUrl();
    }

    public ValidatingStringParameterValue getDefaultParameterValue() {
        ValidatingStringParameterValue v = new ValidatingStringParameterValue(this.getName(), this.defaultValue, this.getRegex(), this.getDescription());
        return v;
    }

    public ParameterValue createValue(StaplerRequest req, JSONObject jo) {
        ValidatingStringParameterValue value = (ValidatingStringParameterValue)((Object)req.bindJSON(ValidatingStringParameterValue.class, jo));
        String req_value = value.getValue();
        if (!Pattern.matches(this.regex, req_value)) {
            throw new Failure("Invalid value for parameter [" + this.getName() + "] specified: " + req_value);
        }
        value.setDescription(this.getDescription());
        value.setRegex(this.regex);
        return value;
    }

    public ParameterValue createValue(StaplerRequest req) {
        String[] value = req.getParameterValues(this.getName());
        if (value == null || value.length < 1) {
            return this.getDefaultParameterValue();
        }
        if (!Pattern.matches(this.regex, value[0])) {
            throw new Failure("Invalid value for parameter [" + this.getName() + "] specified: " + value[0]);
        }
        return new ValidatingStringParameterValue(this.getName(), value[0], this.regex, this.getDescription());
    }

    static {
        replacements.put("\\", "\\\\");
        replacements.put("\"", "\\\"");
    }

    @Extension
    @Symbol(value={"validatingString"})
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public String getDisplayName() {
            return "Validating String Parameter";
        }

        public String getHelpFile() {
            return "/plugin/validating-string-parameter/help.html";
        }

        public FormValidation doCheckRegex(@QueryParameter String value) {
            try {
                Pattern.compile(value);
                return FormValidation.ok();
            }
            catch (PatternSyntaxException pse) {
                return FormValidation.error((String)("Invalid regular expression: " + pse.getDescription()));
            }
        }

        public FormValidation doValidate(@QueryParameter(value="regex") String regex, @QueryParameter(value="failedValidationMessage") String failedValidationMessage, @QueryParameter(value="value") String value) {
            try {
                if (Pattern.matches(regex, value)) {
                    return FormValidation.ok();
                }
                return failedValidationMessage == null || "".equals(failedValidationMessage) ? FormValidation.error((String)("Value entered does not match regular expression: " + regex)) : FormValidation.error((String)failedValidationMessage);
            }
            catch (PatternSyntaxException pse) {
                return FormValidation.error((String)("Invalid regular expression [" + regex + "]: " + pse.getDescription()));
            }
        }
    }
}

