/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.validating_string_parameter;

import hudson.AbortException;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.StringParameterValue;
import hudson.tasks.BuildWrapper;
import java.io.IOException;
import java.util.regex.Pattern;
import org.kohsuke.stapler.DataBoundConstructor;

public class ValidatingStringParameterValue
extends StringParameterValue {
    private String regex;

    @DataBoundConstructor
    public ValidatingStringParameterValue(String name, String value) {
        this(name, value, null, null);
    }

    public ValidatingStringParameterValue(String name, String value, String regex, String description) {
        super(name, value, description);
        this.regex = regex;
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public String getValue() {
        return this.value;
    }

    public BuildWrapper createBuildWrapper(AbstractBuild<?, ?> build) {
        if (!Pattern.matches(this.regex, this.value)) {
            return new BuildWrapper(){

                public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
                    throw new AbortException("Invalid value for parameter [" + ValidatingStringParameterValue.this.getName() + "] specified: " + ValidatingStringParameterValue.this.value);
                }
            };
        }
        return null;
    }

    public int hashCode() {
        int prime = 71;
        int result = super.hashCode();
        result = 71 * result;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ValidatingStringParameterValue other = (ValidatingStringParameterValue)((Object)obj);
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return "(ValidatingStringParameterValue) " + this.getName() + "='" + this.value + "'";
    }
}

