/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.subversion;

import hudson.ExtensionPoint;
import hudson.model.AbstractDescribableImpl;
import hudson.model.TaskListener;
import hudson.scm.RevisionParameterAction;
import hudson.scm.SubversionSCM;
import hudson.scm.SvnClientManager;
import hudson.scm.subversion.WorkspaceUpdaterDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.kohsuke.stapler.export.ExportedBean;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExportedBean
public abstract class WorkspaceUpdater
extends AbstractDescribableImpl<WorkspaceUpdater>
implements ExtensionPoint,
Serializable {
    private static final long serialVersionUID = 8902811304319899817L;

    public abstract UpdateTask createTask();

    public WorkspaceUpdaterDescriptor getDescriptor() {
        return (WorkspaceUpdaterDescriptor)super.getDescriptor();
    }

    protected static boolean isAuthenticationFailedError(SVNCancelException e) {
        if (String.valueOf(e.getMessage()).contains("No credential to try") || String.valueOf(e.getMessage()).contains("authentication cancelled")) {
            return true;
        }
        Throwable cause = e.getCause();
        if (cause instanceof SVNCancelException) {
            return WorkspaceUpdater.isAuthenticationFailedError((SVNCancelException)cause);
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class UpdateTask
    implements Serializable {
        public SVNClientManager manager;
        public SvnClientManager clientManager;
        public ISVNAuthenticationProvider authProvider;
        public Date timestamp;
        public TaskListener listener;
        public SubversionSCM.ModuleLocation location;
        public File ws;
        public RevisionParameterAction revisions;
        private static final long serialVersionUID = 1L;

        public abstract List<SubversionSCM.External> perform() throws IOException, InterruptedException;

        protected List<SubversionSCM.External> delegateTo(UpdateTask t) throws IOException, InterruptedException {
            t.manager = this.manager;
            t.clientManager = this.clientManager;
            t.authProvider = this.authProvider;
            t.timestamp = this.timestamp;
            t.listener = this.listener;
            t.location = this.location;
            t.revisions = this.revisions;
            t.ws = this.ws;
            return t.perform();
        }

        protected final List<SubversionSCM.External> delegateTo(WorkspaceUpdater wu) throws IOException, InterruptedException {
            return this.delegateTo(wu.createTask());
        }

        protected SVNRevision getRevision(SubversionSCM.ModuleLocation l) {
            SVNRevision r = null;
            if (this.revisions != null) {
                r = this.revisions.getRevision(l.getURL());
            }
            if (r == null) {
                r = SVNRevision.create((Date)this.timestamp);
            }
            r = l.getRevision(r);
            return r;
        }

        protected static SVNDepth getSvnDepth(String name) {
            return SVNDepth.fromString((String)name);
        }
    }
}

