/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.listtagsparameter;

import hudson.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleSVNDirEntryHandler
implements ISVNDirEntryHandler {
    private final List<SVNDirEntry> dirs = new ArrayList<SVNDirEntry>();
    private final Pattern filterPattern;

    public SimpleSVNDirEntryHandler(String filter) {
        this.filterPattern = Util.fixEmpty((String)filter) != null ? Pattern.compile(filter) : null;
    }

    public List<String> getDirs() {
        return this.getDirs(false, false);
    }

    @Nonnull
    public List<String> getDirs(boolean reverseByDate, boolean reverseByName) {
        if (reverseByDate) {
            Collections.sort(this.dirs, new Comparator<SVNDirEntry>(){

                @Override
                public int compare(SVNDirEntry dir1, SVNDirEntry dir2) {
                    return dir2.getDate().compareTo(dir1.getDate());
                }
            });
        } else if (reverseByName) {
            Collections.sort(this.dirs, new Comparator<SVNDirEntry>(){

                @Override
                public int compare(SVNDirEntry dir1, SVNDirEntry dir2) {
                    return dir2.getName().compareTo(dir1.getName());
                }
            });
        } else {
            Collections.sort(this.dirs, new Comparator<SVNDirEntry>(){

                @Override
                public int compare(SVNDirEntry dir1, SVNDirEntry dir2) {
                    return dir1.getName().compareTo(dir2.getName());
                }
            });
        }
        ArrayList<String> sortedDirs = new ArrayList<String>();
        for (SVNDirEntry dirEntry : this.dirs) {
            sortedDirs.add(dirEntry.getName());
        }
        return sortedDirs;
    }

    public void handleDirEntry(SVNDirEntry dirEntry) throws SVNException {
        if (this.filterPattern == null || this.filterPattern.matcher(dirEntry.getName()).matches()) {
            this.dirs.add(dirEntry);
        }
    }
}

