/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.browsers;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SubversionChangeLogSet;
import hudson.scm.SubversionRepositoryBrowser;
import hudson.scm.browsers.QueryBuilder;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.kohsuke.stapler.DataBoundConstructor;

public class Assembla
extends SubversionRepositoryBrowser {
    public final String spaceName;
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public Assembla(String spaceName) throws MalformedURLException {
        this.spaceName = spaceName;
    }

    private URL getAssemblaBasePath(String path) throws IOException {
        String fullPath = String.format("https://www.assembla.com/code/%s/subversion/%s/", this.spaceName, path);
        return new URL(fullPath);
    }

    public URL getDiffLink(SubversionChangeLogSet.Path path) throws IOException {
        if (path.getEditType() != EditType.EDIT) {
            return null;
        }
        int revision = path.getLogEntry().getRevision();
        String command = String.format("node/diff/%d/%d", revision, revision - 1);
        String pathWithoutSlash = Assembla.trimHeadSlash((String)path.getValue());
        return new URL(this.getAssemblaBasePath(command), pathWithoutSlash + this.params());
    }

    public URL getFileLink(SubversionChangeLogSet.Path path) throws IOException {
        int revision = path.getLogEntry().getRevision();
        String pathWithoutSlash = Assembla.trimHeadSlash((String)path.getValue());
        String command = pathWithoutSlash + this.params().add("rev=" + revision);
        return new URL(this.getAssemblaBasePath("nodes"), command);
    }

    public URL getChangeSetLink(SubversionChangeLogSet.LogEntry changeSet) throws IOException {
        int revision = changeSet.getRevision();
        String path = String.format("changesets/%d", revision);
        return this.getAssemblaBasePath(path);
    }

    private QueryBuilder params() {
        return new QueryBuilder("");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends Descriptor<RepositoryBrowser<?>> {
        public String getDisplayName() {
            return "Assembla";
        }
    }
}

