/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.scm.SubversionSCM;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.SlaveToMasterCallable;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNAdminAreaFactorySelector;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;

public class SubversionWorkspaceSelector
implements ISVNAdminAreaFactorySelector {
    public static volatile int workspaceFormat = 8;
    public static final int WC_FORMAT_17 = 29;
    public static final int OLD_WC_FORMAT_17 = 100;
    private static final Logger LOGGER = Logger.getLogger(SubversionWorkspaceSelector.class.getName());

    public SubversionWorkspaceSelector() {
        SVNAdminAreaFactory.setUpgradeEnabled((boolean)false);
    }

    public Collection getEnabledFactories(File path, Collection factories, boolean writeAccess) throws SVNException {
        if (!writeAccess) {
            return factories;
        }
        ArrayList<SVNAdminAreaFactory> enabledFactories = new ArrayList<SVNAdminAreaFactory>();
        for (SVNAdminAreaFactory factory : factories) {
            if (factory.getSupportedVersion() != workspaceFormat) continue;
            enabledFactories.add(factory);
        }
        if (enabledFactories.isEmpty() && workspaceFormat != 8) {
            workspaceFormat = 8;
            return this.getEnabledFactories(path, factories, writeAccess);
        }
        return enabledFactories;
    }

    public static void syncWorkspaceFormatFromMaster() {
        Jenkins j = Jenkins.getInstanceOrNull();
        if (j != null) {
            workspaceFormat = ((SubversionSCM.DescriptorImpl)j.getDescriptorByType(SubversionSCM.DescriptorImpl.class)).getWorkspaceFormat();
        } else {
            Channel c = Channel.current();
            if (c != null) {
                try {
                    workspaceFormat = (Integer)c.call((Callable)new GetWorkspaceFormatSlaveToMasterCallable());
                }
                catch (IOException | InterruptedException e) {
                    LOGGER.log(Level.WARNING, "Failed to retrieve Subversion workspace format", e);
                }
            }
        }
    }

    private static class GetWorkspaceFormatSlaveToMasterCallable
    extends SlaveToMasterCallable<Integer, RuntimeException> {
        private static final long serialVersionUID = 6494337549896104453L;

        private GetWorkspaceFormatSlaveToMasterCallable() {
        }

        public Integer call() {
            return ((SubversionSCM.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(SubversionSCM.DescriptorImpl.class)).getWorkspaceFormat();
        }
    }
}

