/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.model.AbstractModelObject;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Job;
import hudson.scm.RevisionParameterAction;
import hudson.scm.SCM;
import hudson.scm.SubversionSCM;
import hudson.triggers.SCMTrigger;
import hudson.util.QueryParameterMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import jenkins.triggers.SCMTriggerItem;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;

public class SubversionRepositoryStatus
extends AbstractModelObject {
    public final UUID uuid;
    private static Method IS_IGNORE_POST_COMMIT_HOOKS_METHOD;
    private static final Logger LOGGER;

    public SubversionRepositoryStatus(UUID uuid) {
        this.uuid = uuid;
    }

    public String getDisplayName() {
        return this.uuid.toString();
    }

    public String getSearchUrl() {
        return this.uuid.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doNotifyCommit(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        QueryParameterMap query;
        String revParam;
        this.requirePOST();
        HashSet<String> affectedPath = new HashSet<String>();
        BufferedReader r = new BufferedReader(req.getReader());
        try {
            String line;
            while ((line = r.readLine()) != null) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Reading line: " + line);
                }
                affectedPath.add(line.substring(4));
                if (!line.startsWith("svnlook changed --revision ")) continue;
                String msg = "Expecting the output from the svnlook command but instead you just sent me the svnlook invocation command line: " + line;
                LOGGER.warning(msg);
                throw new IllegalArgumentException(msg);
            }
        }
        finally {
            IOUtils.closeQuietly((Reader)r);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Change reported to Subversion repository " + this.uuid + " on " + affectedPath);
        }
        if ((revParam = (query = new QueryParameterMap((HttpServletRequest)req)).get("rev")) == null) {
            revParam = req.getHeader("X-Hudson-Subversion-Revision");
        }
        long rev = -1L;
        if (revParam != null) {
            rev = Long.parseLong(revParam);
        }
        boolean listenerDidSomething = false;
        Jenkins instance = Jenkins.getInstance();
        if (instance == null) {
            LOGGER.warning("Jenkins instance is null.");
            return;
        }
        for (Listener listener : instance.getExtensionList(Listener.class)) {
            try {
                if (!listener.onNotify(this.uuid, rev, affectedPath)) continue;
                listenerDidSomething = true;
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Listener " + listener.getClass().getName() + " threw an uncaught exception", t);
            }
        }
        if (!listenerDidSomething) {
            LOGGER.log(Level.WARNING, "No interest in change to repository UUID {0} found", this.uuid);
        }
        rsp.setStatus(200);
    }

    private static boolean doesIgnorePostCommitHooks(SCMTrigger trigger) {
        if (IS_IGNORE_POST_COMMIT_HOOKS_METHOD == null) {
            return false;
        }
        try {
            return (Boolean)IS_IGNORE_POST_COMMIT_HOOKS_METHOD.invoke((Object)trigger, (Object[])null);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failure when calling isIgnorePostCommitHooks", e);
            return false;
        }
    }

    static {
        try {
            IS_IGNORE_POST_COMMIT_HOOKS_METHOD = SCMTrigger.class.getMethod("isIgnorePostCommitHooks", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LOGGER = Logger.getLogger(SubversionRepositoryStatus.class.getName());
    }

    @Extension
    public static class JobTriggerListenerImpl
    extends Listener {
        private Map<String, UUID> remoteUUIDCache = new HashMap<String, UUID>();
        private JobProvider jobProvider = new JobProvider(){

            @Override
            public List<Job> getAllJobs() {
                Jenkins instance = Jenkins.getInstance();
                return instance != null ? instance.getAllItems(Job.class) : Collections.emptyList();
            }
        };

        void setJobProvider(JobProvider jobProvider) {
            this.jobProvider = jobProvider;
        }

        private SubversionRepoUUIDAndRootPath remoteUUIDAndRootPathFromCacheOrFromSVN(Job job, SCM scm, SubversionSCM.ModuleLocation moduleLocation, String urlFromConfiguration) throws SVNException {
            SubversionRepoUUIDAndRootPath uuidAndRootPath = null;
            for (Map.Entry<String, UUID> e : this.remoteUUIDCache.entrySet()) {
                String remoteRepoRootURL = e.getKey();
                String remoteRepoRootURLWithSlash = remoteRepoRootURL + "/";
                if (!urlFromConfiguration.startsWith(remoteRepoRootURLWithSlash) && !urlFromConfiguration.equals(remoteRepoRootURL)) continue;
                UUID uuid = e.getValue();
                String rootPath = SVNURL.parseURIDecoded((String)e.getKey()).getPath();
                uuidAndRootPath = new SubversionRepoUUIDAndRootPath(uuid, rootPath);
                LOGGER.finer("Using cached uuid for module location " + urlFromConfiguration + " of job " + job);
                break;
            }
            if (uuidAndRootPath == null) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Could not find " + urlFromConfiguration + " in " + this.remoteUUIDCache.keySet());
                }
                UUID remoteUUID = moduleLocation.getUUID(job, scm);
                SVNURL repositoryRoot = moduleLocation.getRepositoryRoot(job, scm);
                this.remoteUUIDCache.put(repositoryRoot.toString(), remoteUUID);
                uuidAndRootPath = new SubversionRepoUUIDAndRootPath(remoteUUID, repositoryRoot.getPath());
            }
            return uuidAndRootPath;
        }

        boolean doModuleLocationHasAPathFromAffectedPath(String configuredRepoFullPath, String rootRepoPath, Set<String> affectedPath) {
            boolean containsAnAffectedPath = false;
            if (configuredRepoFullPath.startsWith(rootRepoPath)) {
                String remainingRepoPath = configuredRepoFullPath.substring(rootRepoPath.length());
                if (remainingRepoPath.startsWith("/")) {
                    remainingRepoPath = remainingRepoPath.substring(1);
                }
                String remainingRepoPathSlash = remainingRepoPath + '/';
                for (String path : affectedPath) {
                    if (!path.equals(remainingRepoPath) && !path.startsWith(remainingRepoPathSlash) && remainingRepoPath.length() != 0) continue;
                    containsAnAffectedPath = true;
                    break;
                }
            }
            return containsAnAffectedPath;
        }

        private void scheduleImediatePollingOfJob(Job job, SCMTrigger trigger, List<SubversionSCM.SvnInfo> infos) {
            LOGGER.fine("Scheduling the immediate polling of " + job);
            RevisionParameterAction[] actions = infos.isEmpty() ? new RevisionParameterAction[]{} : new RevisionParameterAction[]{new RevisionParameterAction(infos)};
            trigger.run((Action[])actions);
        }

        @Override
        public boolean onNotify(UUID uuid, long rev, Set<String> affectedPath) {
            boolean scmFound = false;
            boolean triggerFound = false;
            boolean uuidFound = false;
            boolean pathFound = false;
            LOGGER.fine("Starting subversion locations checks for all jobs");
            block5: for (Job p : this.jobProvider.getAllJobs()) {
                SCMTriggerItem scmTriggerItem = SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem((Item)p);
                if (scmTriggerItem == null || p instanceof AbstractProject && ((AbstractProject)p).isDisabled()) continue;
                String jobName = p.getName();
                for (SCM scm : scmTriggerItem.getSCMs()) {
                    if (!(scm instanceof SubversionSCM)) continue;
                    scmFound = true;
                    SCMTrigger trigger = scmTriggerItem.getSCMTrigger();
                    if (trigger == null || SubversionRepositoryStatus.doesIgnorePostCommitHooks(trigger)) continue;
                    triggerFound = true;
                    SubversionSCM sscm = (SubversionSCM)scm;
                    ArrayList<SubversionSCM.SvnInfo> infos = new ArrayList<SubversionSCM.SvnInfo>();
                    try {
                        boolean projectMatches = false;
                        for (SubversionSCM.ModuleLocation loc : sscm.getProjectLocations(p)) {
                            String urlFromConfiguration = loc.getURL();
                            try {
                                SubversionRepoUUIDAndRootPath uuidAndRootPath = this.remoteUUIDAndRootPathFromCacheOrFromSVN(p, sscm, loc, urlFromConfiguration);
                                UUID remoteUUID = uuidAndRootPath.uuid;
                                if (!remoteUUID.equals(uuid)) continue;
                                uuidFound = true;
                                String configuredRepoFullPath = loc.getSVNURL().getPath();
                                String rootRepoPath = uuidAndRootPath.rootPath;
                                if (this.doModuleLocationHasAPathFromAffectedPath(configuredRepoFullPath, rootRepoPath, affectedPath)) {
                                    projectMatches = true;
                                    pathFound = true;
                                }
                                if (rev != -1L) {
                                    infos.add(new SubversionSCM.SvnInfo(loc.getURL(), rev));
                                }
                            }
                            catch (SVNCancelException e) {
                                LOGGER.log(Level.WARNING, "Failed to handle Subversion commit notification (was trying to access " + urlFromConfiguration + " of job " + jobName + "). If you are using svn:externals feature ensure that the credentials of the externals are added on the Additional Credentials field", e);
                            }
                            catch (SVNException e) {
                                LOGGER.log(Level.WARNING, "Failed to handle Subversion commit notification (was trying to access " + urlFromConfiguration + " of job " + jobName + ")", e);
                            }
                            if (!projectMatches) continue;
                            this.scheduleImediatePollingOfJob(p, trigger, infos);
                            continue block5;
                        }
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Failed to handle Subversion commit notification (getting module locations failed for job " + jobName + ")", e);
                    }
                }
            }
            LOGGER.fine("Ended subversion locations checks for all jobs");
            if (!scmFound) {
                LOGGER.warning("No subversion jobs found");
            } else if (!triggerFound) {
                LOGGER.warning("No subversion jobs using SCM polling or all jobs using SCM polling are ignoring post-commit hooks");
            } else if (!uuidFound) {
                LOGGER.warning("No subversion jobs using repository: " + uuid);
            } else if (!pathFound) {
                LOGGER.fine("No jobs found matching the modified files");
            }
            return scmFound;
        }
    }

    private static class SubversionRepoUUIDAndRootPath {
        public final UUID uuid;
        public final String rootPath;

        public SubversionRepoUUIDAndRootPath(UUID uuid, String rootPath) {
            this.uuid = uuid;
            this.rootPath = rootPath;
        }
    }

    public static abstract class Listener
    implements ExtensionPoint {
        public abstract boolean onNotify(UUID var1, long var2, Set<String> var4);
    }

    static interface JobProvider {
        public List<Job> getAllJobs();
    }
}

