/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import hudson.XmlFile;
import hudson.model.AbstractProject;
import hudson.model.Saveable;
import hudson.remoting.Channel;
import hudson.scm.SubversionSCM;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;

final class PerJobCredentialStore
implements Saveable,
SubversionSCM.DescriptorImpl.RemotableSVNAuthenticationProvider {
    private static final long serialVersionUID = 8509067873170016632L;
    private final transient AbstractProject<?, ?> project;
    private final Map<String, SubversionSCM.DescriptorImpl.Credential> credentials = new Hashtable<String, SubversionSCM.DescriptorImpl.Credential>();
    private static final Logger LOGGER = Logger.getLogger(PerJobCredentialStore.class.getName());
    private static final ThreadLocal<Boolean> IS_SAVING = new ThreadLocal();

    PerJobCredentialStore(AbstractProject<?, ?> project) {
        this.project = project;
        XmlFile xml = this.getXmlFile();
        try {
            if (xml.exists()) {
                xml.unmarshal((Object)this);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Failed to retrieve Subversion credentials from " + xml, e);
        }
    }

    public synchronized SubversionSCM.DescriptorImpl.Credential get(String realm) {
        return this.credentials.get(realm);
    }

    @Override
    public SubversionSCM.DescriptorImpl.Credential getCredential(SVNURL url, String realm) {
        return this.get(realm);
    }

    @Override
    public void acknowledgeAuthentication(String realm, SubversionSCM.DescriptorImpl.Credential cred) {
        try {
            this.acknowledge(realm, cred);
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Failed to persist the credentials", e);
        }
    }

    public synchronized void acknowledge(String realm, SubversionSCM.DescriptorImpl.Credential cred) throws IOException {
        SubversionSCM.DescriptorImpl.Credential old;
        SubversionSCM.DescriptorImpl.Credential credential = old = cred == null ? this.credentials.remove(realm) : this.credentials.put(realm, cred);
        if (old == null && cred == null) {
            return;
        }
        if (old == null || cred == null || !old.equals(cred)) {
            this.save();
        }
    }

    public synchronized void save() throws IOException {
        IS_SAVING.set(Boolean.TRUE);
        try {
            this.getXmlFile().write((Object)this);
        }
        finally {
            IS_SAVING.remove();
        }
    }

    private XmlFile getXmlFile() {
        return new XmlFile(new File(this.project.getRootDir(), "subversion.credentials"));
    }

    synchronized boolean isEmpty() {
        return this.credentials.isEmpty();
    }

    private Object writeReplace() {
        if (IS_SAVING.get() != null) {
            return this;
        }
        Channel c = Channel.current();
        return c == null ? this : (SubversionSCM.DescriptorImpl.RemotableSVNAuthenticationProvider)c.export(SubversionSCM.DescriptorImpl.RemotableSVNAuthenticationProvider.class, (Object)this);
    }

    void migrateCredentials(SubversionSCM.DescriptorImpl descriptor) throws IOException {
        Iterable it = CredentialsProvider.lookupStores(this.project);
        if (it != null && it.iterator().hasNext()) {
            CredentialsStore store = (CredentialsStore)it.iterator().next();
            block2: for (Map.Entry<String, SubversionSCM.DescriptorImpl.Credential> e : this.credentials.entrySet()) {
                StandardCredentials credential = descriptor.migrateCredentials(store, e.getKey(), e.getValue());
                SubversionSCM.ModuleLocation[] locations = ((SubversionSCM)this.project.getScm()).getLocations();
                for (int i = 0; i < locations.length; ++i) {
                    try {
                        if (!e.getKey().contains(locations[i].getSVNURL().getHost())) continue;
                        locations[i].setCredentialsId(credential.getId());
                        continue block2;
                    }
                    catch (SVNException ex) {
                        LOGGER.log(Level.WARNING, "Repository location with a malformed URL: " + locations[i].remote, ex);
                    }
                }
            }
        }
    }
}

