/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.structs;

import hudson.Extension;
import hudson.PluginManager;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import jenkins.model.Jenkins;
import org.codehaus.groovy.tools.Utilities;
import org.jenkinsci.Symbol;
import org.jvnet.hudson.annotation_indexer.Index;

@Extension
public class SymbolLookup {
    private final ConcurrentMap<Key, Object> cache = new ConcurrentHashMap<Key, Object>();
    @Inject
    PluginManager pluginManager;
    @Inject
    Jenkins jenkins;
    private static final Logger LOGGER = Logger.getLogger(SymbolLookup.class.getName());

    public <T> T find(Class<T> type, String symbol) {
        try {
            Key k = new Key(type, symbol);
            Object i = this.cache.get(k);
            if (i != null) {
                return type.cast(i);
            }
            if (!Utilities.isJavaIdentifier((String)symbol)) {
                return null;
            }
            for (Class e : Index.list(Symbol.class, (ClassLoader)this.pluginManager.uberClassLoader, Class.class)) {
                Symbol s;
                if (!type.isAssignableFrom(e) || (s = e.getAnnotation(Symbol.class)) == null) continue;
                for (String t : s.value()) {
                    if (!t.equals(symbol)) continue;
                    i = this.jenkins.getInjector().getInstance(e);
                    this.cache.put(k, i);
                    return type.cast(i);
                }
            }
            return null;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Unable to find @Symbol", e);
            return null;
        }
    }

    public static SymbolLookup get() {
        Jenkins j = Jenkins.getInstance();
        if (j == null) {
            throw new IllegalStateException();
        }
        return (SymbolLookup)j.getInjector().getInstance(SymbolLookup.class);
    }

    private static class Key {
        private final Class type;
        private final String name;

        public Key(Class type, String name) {
            this.type = type;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.type == key.type && this.name.equals(key.name);
        }

        public int hashCode() {
            return 31 * this.type.hashCode() + this.name.hashCode();
        }
    }
}

