/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsmith.jenkins.stackhammer.validation;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.tasks.Builder;
import java.io.PrintStream;
import java.net.URI;
import org.cloudsmith.jenkins.stackhammer.validation.ValidationDescriptor;
import org.cloudsmith.jenkins.stackhammer.validation.ValidationResult;
import org.cloudsmith.stackhammer.api.StackHammerModule;
import org.cloudsmith.stackhammer.api.model.Provider;
import org.cloudsmith.stackhammer.api.model.Repository;
import org.cloudsmith.stackhammer.api.model.ResultWithDiagnostic;
import org.cloudsmith.stackhammer.api.service.RepositoryService;
import org.cloudsmith.stackhammer.api.service.StackHammerFactory;
import org.cloudsmith.stackhammer.api.service.StackService;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Validator
extends Builder {
    private final String branch;
    private final String stack;
    private final String apiKey;

    @DataBoundConstructor
    public Validator(String stack, String branch, String apiKey) {
        this.stack = stack;
        this.branch = branch;
        this.apiKey = apiKey;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getBranch() {
        return this.branch;
    }

    public ValidationDescriptor getDescriptor() {
        return (ValidationDescriptor)super.getDescriptor();
    }

    public String getStack() {
        return this.stack;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        try {
            PrintStream logger = listener.getLogger();
            String serverURL = this.getDescriptor().getServiceURL();
            URI uri = URI.create(serverURL);
            logger.format("Using parameters%n scheme=%s%n host=%s%n port=%s%n prefix=%s%n", uri.getScheme(), uri.getHost(), uri.getPort(), uri.getPath());
            Injector injector = Guice.createInjector((Module[])new Module[]{new StackHammerModule(uri.getScheme(), uri.getHost(), uri.getPort(), uri.getPath(), this.getApiKey())});
            ValidationResult data = new ValidationResult(build);
            build.addAction((Action)data);
            StackHammerFactory factory = (StackHammerFactory)injector.getInstance(StackHammerFactory.class);
            RepositoryService repoService = factory.createRepositoryService();
            String[] splitName = this.getStack().split("/");
            String owner = splitName[0];
            String name = splitName[1];
            logger.format("Verifying that a local clone of repository %s/%s[%s] exists at Stack Hammer Service%n", owner, name, this.branch);
            ResultWithDiagnostic cloneResult = repoService.cloneRepository(Provider.GITHUB, owner, name, this.branch);
            data.setCloneDiagnostic((ResultWithDiagnostic<Repository>)cloneResult);
            if (cloneResult.getSeverity() == 4) {
                listener.error(cloneResult.toString());
                return false;
            }
            cloneResult.log(logger);
            StackService stackService = factory.createStackService();
            Repository repo = (Repository)cloneResult.getResult();
            logger.format("Sending order to validate stack %s/%s%n", owner, name);
            org.cloudsmith.stackhammer.api.model.ValidationResult validationResult = stackService.validateStack(repo, repo.getOwner() + "/" + repo.getName());
            data.setResult(validationResult);
            if (validationResult.getSeverity() == 4) {
                listener.error(validationResult.toString());
                return false;
            }
            validationResult.log(logger);
        }
        catch (Exception e) {
            e.printStackTrace(listener.error("Exception during validation of %s", new Object[]{this.getStack()}));
            return false;
        }
        return true;
    }
}

