/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsmith.jenkins.stackhammer.validation;

import hudson.Functions;
import hudson.model.AbstractBuild;
import java.io.IOException;
import javax.servlet.ServletOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.cloudsmith.jenkins.stackhammer.common.StackOpResult;
import org.cloudsmith.stackhammer.api.model.Repository;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExportedBean(defaultVisibility=999)
public class ValidationResult
extends StackOpResult<String> {
    private static final long serialVersionUID = 264848698476660935L;

    public ValidationResult(AbstractBuild<?, ?> build) {
        super(build);
    }

    public ValidationResult clone() {
        ValidationResult clone;
        try {
            clone = (ValidationResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Error cloning ValidationResult", e);
        }
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDependencyGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        String name = req.getRestOfPath();
        String result = (String)this.getResult();
        if ((name == null || name.isEmpty()) && result != null) {
            rsp.setContentType("image/svg+xml");
            ServletOutputStream out = rsp.getOutputStream();
            try {
                byte[] svgData = Base64.decodeBase64((String)result);
                rsp.setContentLength(svgData.length);
                out.write(svgData);
                return;
            }
            finally {
                out.close();
            }
        }
        rsp.sendError(404);
    }

    public String getDisplayName() {
        return "Validation Results";
    }

    @Override
    public String getIconFileName() {
        return Functions.getResourcePath() + "/plugin/stackhammer/icons/hammer-32x32.png";
    }

    @Override
    public String getLargeIconFileName() {
        return "/plugin/stackhammer/icons/hammer-48x48.png";
    }

    public String getStackBase() {
        Repository repo = this.getRepository();
        return repo == null ? null : repo.getProvider().getRepositoryBase(repo.getOwner(), repo.getName(), repo.getBranch());
    }

    public String getSummary() {
        return this.getSummary(this.getResultDiagnostics());
    }

    public String getSummaryValidationGraphURL() {
        return this.getResult() != null ? this.getUrlFor("dependencyGraph") : null;
    }

    @Override
    public String getTitle() {
        return "Validation Result";
    }

    public String getUrlName() {
        return "validationReport";
    }

    public String getValidationGraphURL() {
        return this.getResult() != null ? "dependencyGraph" : null;
    }
}

