/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.ssh2easy.gssh;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.PrintStream;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.plugins.ssh2easy.gssh.GsshBuilderWrapper;
import jenkins.plugins.ssh2easy.gssh.GsshShellBuilder;
import jenkins.plugins.ssh2easy.gssh.Messages;
import jenkins.plugins.ssh2easy.gssh.Server;
import jenkins.plugins.ssh2easy.gssh.client.SshClient;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class GsshFtpDownloadBuilder
extends Builder {
    public static final Logger LOGGER = Logger.getLogger(GsshShellBuilder.class.getName());
    private boolean disable;
    private String serverInfo;
    private String groupName;
    private String ip;
    private String remoteFile;
    private String localFolder;
    private String fileName;

    public GsshFtpDownloadBuilder() {
    }

    @DataBoundConstructor
    public GsshFtpDownloadBuilder(boolean disable, String serverInfo, String remoteFile, String localFolder, String fileName) {
        this.disable = disable;
        this.serverInfo = serverInfo;
        this.ip = Server.parseIp(this.serverInfo);
        this.groupName = Server.parseServerGroupName(this.serverInfo);
        this.remoteFile = remoteFile;
        this.localFolder = localFolder;
        this.fileName = Util.fixEmptyAndTrim((String)fileName);
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        PrintStream logger = listener.getLogger();
        GsshBuilderWrapper.printSplit(logger);
        if (this.isDisable()) {
            logger.println("current step is disabled , skip to execute");
            return true;
        }
        logger.println("execute on server -- " + this.getServerInfo());
        SshClient sshClient = GsshBuilderWrapper.DESCRIPTOR.getSshClient(this.getGroupName(), this.getIp());
        int exitStatus = -1;
        try {
            EnvVars env = build.getEnvironment((TaskListener)listener);
            File file = new File(Util.replaceMacro((String)this.getLocalFolder(), (Map)env));
            if (null == this.fileName) {
                this.fileName = file.getName();
            }
            exitStatus = sshClient.downloadFile(logger, this.remoteFile, this.localFolder, this.fileName);
            GsshBuilderWrapper.printSplit(logger);
        }
        catch (Exception e) {
            return false;
        }
        return exitStatus == 0;
    }

    public String getServerInfo() {
        return this.serverInfo;
    }

    public void setServerInfo(String serverInfo) {
        this.serverInfo = serverInfo;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public boolean isDisable() {
        return this.disable;
    }

    public void setDisable(boolean disable) {
        this.disable = disable;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getRemoteFile() {
        return this.remoteFile;
    }

    public void setRemoteFile(String remoteFile) {
        this.remoteFile = remoteFile;
    }

    public String getLocalFolder() {
        return this.localFolder;
    }

    public void setLocalFolder(String localFolder) {
        this.localFolder = localFolder;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.SSHFTPDOWNLOAD_DisplayName();
        }

        public Builder newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (Builder)req.bindJSON(this.clazz, formData);
        }

        public ListBoxModel doFillServerInfoItems() {
            ListBoxModel m = new ListBoxModel();
            for (Server server : GsshBuilderWrapper.DESCRIPTOR.getServers()) {
                m.add(server.getServerInfo());
            }
            return m;
        }
    }
}

