/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.ssh2easy.gssh;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.CopyOnWriteList;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.plugins.ssh2easy.gssh.Messages;
import jenkins.plugins.ssh2easy.gssh.Server;
import jenkins.plugins.ssh2easy.gssh.ServerGroup;
import jenkins.plugins.ssh2easy.gssh.client.SshClient;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public final class GsshBuilderWrapper
extends BuildWrapper {
    public static final Logger LOGGER = Logger.getLogger(GsshBuilderWrapper.class.getName());
    @Extension
    public static final GsshDescriptorImpl DESCRIPTOR = new GsshDescriptorImpl();
    private boolean disable;
    private String serverInfo;
    private String preScript;
    private String postScript;
    private String groupName;
    private String ip;

    public GsshBuilderWrapper() {
    }

    @DataBoundConstructor
    public GsshBuilderWrapper(boolean disable, String serverInfo, String preScript, String postScript) {
        this.disable = disable;
        this.serverInfo = serverInfo;
        this.initHook();
        this.preScript = preScript;
        this.postScript = postScript;
    }

    private void initHook() {
        this.groupName = Server.parseServerGroupName(this.serverInfo);
        this.ip = Server.parseIp(this.serverInfo);
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        BuildWrapper.Environment env = new BuildWrapper.Environment(){

            public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
                GsshBuilderWrapper.this.executePostBuildScript(listener.getLogger());
                return super.tearDown(build, listener);
            }
        };
        this.executePreBuildScript(listener.getLogger());
        return env;
    }

    private boolean executePreBuildScript(PrintStream logger) {
        GsshBuilderWrapper.printSplit(logger);
        logger.println("execute on server -- " + this.getServerInfo());
        if (this.isDisable()) {
            logger.println("current step is disabled , skip to execute");
            return true;
        }
        this.initHook();
        this.log(logger, "executing pre build script as below :\n" + this.preScript);
        SshClient sshHandler = this.getSshClient();
        int exitStatus = -1;
        if (this.preScript != null && !this.preScript.trim().equals("")) {
            exitStatus = sshHandler.executeShellByFTP(logger, this.preScript);
        }
        GsshBuilderWrapper.printSplit(logger);
        return exitStatus == 0;
    }

    private boolean executePostBuildScript(PrintStream logger) {
        GsshBuilderWrapper.printSplit(logger);
        logger.println("execute on server -- " + this.getServerInfo());
        if (this.isDisable()) {
            logger.println("current step is disabled , skip to execute");
            return true;
        }
        this.initHook();
        this.log(logger, "executing post build script as below :\n" + this.postScript);
        SshClient sshHandler = this.getSshClient();
        int exitStatus = -1;
        if (this.postScript != null && !this.postScript.trim().equals("")) {
            exitStatus = sshHandler.executeShellByFTP(logger, this.postScript);
        }
        GsshBuilderWrapper.printSplit(logger);
        return exitStatus == 0;
    }

    public static void printSplit(PrintStream logger) {
        logger.println("##########################################################################");
    }

    public SshClient getSshClient() {
        return DESCRIPTOR.getSshClient(this.getGroupName(), this.getIp());
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    private void log(PrintStream logger, String message) {
        logger.println(StringUtils.defaultString((String)DESCRIPTOR.getShortName()) + message);
    }

    public boolean isDisable() {
        return this.disable;
    }

    public void setDisable(boolean disable) {
        this.disable = disable;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getPreScript() {
        return this.preScript;
    }

    public void setPreScript(String preScript) {
        this.preScript = preScript;
    }

    public String getPostScript() {
        return this.postScript;
    }

    public void setPostScript(String postScript) {
        this.postScript = postScript;
    }

    public String getServerInfo() {
        return this.serverInfo;
    }

    public void setServerInfo(String serverInfo) {
        this.serverInfo = serverInfo;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String toString() {
        return this.groupName + " +++ " + this.ip + " +++ " + this.serverInfo;
    }

    public static class GsshDescriptorImpl
    extends BuildWrapperDescriptor {
        public static final Logger LOGGER = Logger.getLogger(GsshDescriptorImpl.class.getName());
        private final CopyOnWriteList<ServerGroup> serverGroups = new CopyOnWriteList();
        private final CopyOnWriteList<Server> servers = new CopyOnWriteList();

        public GsshDescriptorImpl() {
            super(GsshBuilderWrapper.class);
            this.load();
        }

        public GsshDescriptorImpl(Class<? extends BuildWrapper> clazz) {
            super(clazz);
            this.load();
        }

        public ServerGroup[] getServerGroups() {
            Iterator it = this.serverGroups.iterator();
            int size = 0;
            while (it.hasNext()) {
                it.next();
                ++size;
            }
            return (ServerGroup[])this.serverGroups.toArray((Object[])new ServerGroup[size]);
        }

        public Server[] getServers() {
            Iterator it = this.servers.iterator();
            int size = 0;
            while (it.hasNext()) {
                it.next();
                ++size;
            }
            return (Server[])this.servers.toArray((Object[])new Server[size]);
        }

        public String getDisplayName() {
            return Messages.SSHSHELL_DisplayName();
        }

        public String getShortName() {
            return "[GSSH] ";
        }

        public String getHelpFile() {
            return "/plugin/ssh2easy/help.html";
        }

        public BuildWrapper newInstance(StaplerRequest req, JSONObject formData) {
            GsshBuilderWrapper pub = new GsshBuilderWrapper();
            req.bindParameters((Object)pub, "gssh.wrapp.");
            return pub;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) {
            this.serverGroups.replaceBy((Collection)req.bindParametersToList(ServerGroup.class, "gssh.sg.wrapper."));
            this.servers.replaceBy((Collection)req.bindParametersToList(Server.class, "gssh.s.wrapper."));
            this.save();
            return true;
        }

        public boolean doServerGroupSubmit(StaplerRequest req, StaplerResponse rsp) {
            this.serverGroups.replaceBy((Collection)req.bindParametersToList(ServerGroup.class, "gssh.sg.wrapper."));
            this.save();
            return true;
        }

        public boolean doServerSubmit(StaplerRequest req, StaplerResponse rsp) {
            this.servers.replaceBy((Collection)req.bindParametersToList(Server.class, "gssh.s.wrapper."));
            this.save();
            return true;
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public ServerGroup getServerGroup(String groupName) {
            ServerGroup[] serverGroups;
            for (ServerGroup servcerGroup : serverGroups = this.getServerGroups()) {
                if (!servcerGroup.getGroupName().trim().equals(groupName.trim())) continue;
                return servcerGroup;
            }
            return null;
        }

        public Server getServer(String ip) {
            Server[] servers;
            for (Server server : servers = this.getServers()) {
                if (!server.getIp().equals(ip)) continue;
                return server;
            }
            return null;
        }

        public SshClient getSshClient(String groupName, String ip) {
            ServerGroup serverGroup = this.getServerGroup(groupName);
            return serverGroup.getSshClient(ip);
        }

        public FormValidation doCheckUsername(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a name");
            }
            if (value.length() < 2) {
                return FormValidation.warning((String)"Isn't the name too short?");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPort(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a port");
            }
            if (value.length() > 4) {
                return FormValidation.warning((String)"Isn't the port too large?");
            }
            try {
                Integer.parseInt(value);
            }
            catch (Exception e) {
                return FormValidation.error((String)"Please input the port as integer");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckGroupName(@QueryParameter String value) throws IOException, ServletException {
            if (null == value) {
                return FormValidation.error((String)"Please input username");
            }
            if (value.length() == 0) {
                return FormValidation.error((String)"Please input username");
            }
            if (value.indexOf("~~") > -1) {
                return FormValidation.error((String)"Your input name contains '~~' that is forbidden");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPassword(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please input password");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckName(@QueryParameter String value) throws IOException, ServletException {
            return this.doCheckGroupName(value);
        }

        public FormValidation doCheckIP(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please input server ip");
            }
            return FormValidation.ok();
        }
    }
}

