/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.ssh2easy.acl;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.ManagementLink;
import hudson.security.AuthorizationStrategy;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.plugins.ssh2easy.acl.CloudCIAuthorizationStrategy;
import jenkins.plugins.ssh2easy.acl.Messages;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension
public class ProjectStrategyConfig
extends ManagementLink {
    public String getIconFileName() {
        String icon = null;
        if (Jenkins.getInstance().getAuthorizationStrategy() instanceof CloudCIAuthorizationStrategy) {
            icon = "cloud_ci_logo.png";
        }
        return icon;
    }

    public String getUrlName() {
        return "projects-members";
    }

    public String getDisplayName() {
        return Messages.CloudCIAuthorizationStrategy_ManageAndAssign();
    }

    public String getAssignProjectsName() {
        return Messages.CloudCIAuthorizationStrategy_Assign();
    }

    public String getManageProjectsName() {
        return Messages.CloudCIAuthorizationStrategy_Manage();
    }

    public String getDescription() {
        return Messages.CloudCIAuthorizationStrategy_Description();
    }

    public AuthorizationStrategy getStrategy() {
        AuthorizationStrategy strategy = Jenkins.getInstance().getAuthorizationStrategy();
        if (strategy instanceof CloudCIAuthorizationStrategy) {
            return strategy;
        }
        return null;
    }

    public void doProjectsSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, UnsupportedEncodingException, ServletException, Descriptor.FormException {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        CloudCIAuthorizationStrategy.DESCRIPTOR.doProjectsSubmit(req, rsp);
        rsp.sendRedirect(".");
    }

    public void doAssignSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, UnsupportedEncodingException, ServletException, Descriptor.FormException {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        CloudCIAuthorizationStrategy.DESCRIPTOR.doAssignSubmit(req, rsp);
        rsp.sendRedirect(".");
    }
}

