/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sharedobjects.type;

import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractBuild;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.plugins.sharedobjects.MultipleSharedObjectType;
import org.jenkinsci.plugins.sharedobjects.SharedObjectException;
import org.jenkinsci.plugins.sharedobjects.SharedObjectType;
import org.jenkinsci.plugins.sharedobjects.SharedObjectTypeDescriptor;
import org.jenkinsci.plugins.sharedobjects.service.SharedObjectLogger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileURLPropertiesSharedObjectType
extends MultipleSharedObjectType {
    private String propertiesFile;

    @DataBoundConstructor
    public FileURLPropertiesSharedObjectType(String name, String profiles, String propertiesFile) {
        super(name, profiles);
        this.propertiesFile = Util.fixEmptyAndTrim((String)propertiesFile);
    }

    public String getPropertiesFile() {
        return this.propertiesFile;
    }

    @Override
    public Map<String, String> getEnvVars(AbstractBuild build, SharedObjectLogger logger) throws SharedObjectException {
        logger.info(String.format("Trying to retrieve a properties file through the url value %s associated to the shared object with the name %s.", this.propertiesFile, this.name));
        if (this.propertiesFile == null) {
            return null;
        }
        File file = new File(this.propertiesFile);
        if (!file.exists()) {
            logger.error(String.format("The file %s doesn't exist.", file));
        }
        try {
            return this.loadProperties(FileUtils.readFileToString((File)file));
        }
        catch (IOException ioe) {
            throw new SharedObjectException(ioe);
        }
    }

    private Map<String, String> loadProperties(String content) throws SharedObjectException {
        HashMap<String, String> result = new HashMap<String, String>();
        Properties properties = new Properties();
        StringReader stringReader = new StringReader(content);
        try {
            properties.load(stringReader);
        }
        catch (IOException ioe) {
            throw new SharedObjectException(ioe);
        }
        stringReader.close();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            result.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class FileURLPropertiesSharedObjectTypeDescriptor
    extends SharedObjectTypeDescriptor {
        public String getDisplayName() {
            return "A public file path to a properties file";
        }

        @Override
        public Class<? extends SharedObjectType> getType() {
            return FileURLPropertiesSharedObjectType.class;
        }
    }
}

