/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sharedobjects;

import hudson.Util;
import hudson.model.AbstractBuild;
import java.util.Map;
import org.jenkinsci.plugins.sharedobjects.SharedObjectException;
import org.jenkinsci.plugins.sharedobjects.SharedObjectType;
import org.jenkinsci.plugins.sharedobjects.service.SharedObjectLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultipleSharedObjectType
extends SharedObjectType {
    protected MultipleSharedObjectType(String name, String profiles) {
        super(name, profiles);
    }

    public Map<String, String> getEnvVarValue(AbstractBuild build, SharedObjectLogger logger) throws SharedObjectException {
        Map<String, String> result = this.getEnvVars(build, logger);
        this.resolveVars(result, result);
        return result;
    }

    public abstract Map<String, String> getEnvVars(AbstractBuild var1, SharedObjectLogger var2) throws SharedObjectException;

    protected void resolveVars(Map<String, String> variables, Map<String, String> env) {
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            String value = Util.replaceMacro((String)entry.getValue(), env);
            entry.setValue(value);
        }
        boolean stopToResolveVars = false;
        int nbUnresolvedVar = 0;
        while (!stopToResolveVars) {
            int previousNbUnresolvedVar = nbUnresolvedVar;
            nbUnresolvedVar = 0;
            for (Map.Entry<String, String> entry : variables.entrySet()) {
                String value = Util.replaceMacro((String)entry.getValue(), variables);
                entry.setValue(value);
                if (!this.isUnresolvedVar(value)) continue;
                ++nbUnresolvedVar;
            }
            if (previousNbUnresolvedVar != nbUnresolvedVar) continue;
            stopToResolveVars = true;
        }
    }

    private boolean isUnresolvedVar(String value) {
        return value != null && value.contains("$") && !value.contains("\\$");
    }
}

