/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sharedobjects.type;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.tasks.Shell;
import java.io.IOException;
import org.jenkinsci.plugins.sharedobjects.SharedObjectException;
import org.jenkinsci.plugins.sharedobjects.SharedObjectType;
import org.jenkinsci.plugins.sharedobjects.SharedObjectTypeDescriptor;
import org.jenkinsci.plugins.sharedobjects.service.SharedObjectLogger;
import org.jenkinsci.plugins.sharedobjects.service.SharedObjectManagementFile;
import org.kohsuke.stapler.DataBoundConstructor;

public class ClearcaseSharedObjectType
extends SharedObjectType {
    private String viewName;
    private String elementPath;

    @DataBoundConstructor
    public ClearcaseSharedObjectType(String name, String viewName, String elementPath) {
        this.name = Util.fixEmpty((String)name);
        this.viewName = Util.fixEmpty((String)viewName);
        this.elementPath = Util.fixEmpty((String)elementPath);
    }

    public String getViewName() {
        return this.viewName;
    }

    public String getElementPath() {
        return this.elementPath;
    }

    public String getEnvVarValue(SharedObjectLogger logger) throws SharedObjectException {
        logger.info(String.format("Executing a cleartool command to retrieve the shared object with the name %s.", this.name));
        SharedObjectManagementFile sharedObjectManagementFile = new SharedObjectManagementFile();
        String tmpFilePath = sharedObjectManagementFile.getTemporaryFilePath(this.name);
        try {
            int cmdCode = this.runCommandAndReturn(String.format("cleartool setview -exec 'cat %s 2>&1 | tee %s' %s", this.elementPath, tmpFilePath, this.viewName), logger.getListener());
            if (cmdCode != 0) {
                throw new SharedObjectException("Command exit on failure.");
            }
            return tmpFilePath;
        }
        catch (IOException ioe) {
            throw new SharedObjectException(ioe);
        }
        catch (InterruptedException ie) {
            throw new SharedObjectException(ie);
        }
    }

    private int runCommandAndReturn(String command, TaskListener listener) throws IOException, InterruptedException {
        listener.getLogger().println("[SharedObject] - Running the command " + command);
        Launcher.LocalLauncher launcher = new Launcher.LocalLauncher(listener);
        Shell batchRunner = new Shell(command);
        FilePath tmpFile = batchRunner.createScriptFile(Hudson.getInstance().getRootPath());
        return launcher.launch().cmds(batchRunner.buildCommandLine(tmpFile)).stdout(launcher.getListener()).join();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class ClearcaseSharedObjectTypeDescriptor
    extends SharedObjectTypeDescriptor {
        public String getDisplayName() {
            return "Clearcase Element";
        }

        @Override
        public Class<? extends SharedObjectType> getType() {
            return ClearcaseSharedObjectType.class;
        }
    }
}

