/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sharedobjects;

import hudson.Extension;
import hudson.model.TaskListener;
import java.util.HashMap;
import java.util.Map;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.plugins.envinject.model.EnvInjectJobPropertyContributor;
import org.jenkinsci.plugins.envinject.model.EnvInjectJobPropertyContributorDescriptor;
import org.jenkinsci.plugins.sharedobjects.SharedObjectException;
import org.jenkinsci.plugins.sharedobjects.SharedObjectType;
import org.jenkinsci.plugins.sharedobjects.service.SharedObjectDataStore;
import org.jenkinsci.plugins.sharedobjects.service.SharedObjectLogger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedObjectJobProperty
extends EnvInjectJobPropertyContributor {
    private boolean populateSharedObjects;

    public SharedObjectJobProperty() {
    }

    @DataBoundConstructor
    public SharedObjectJobProperty(boolean populateSharedObjects) {
        this.populateSharedObjects = populateSharedObjects;
    }

    public boolean getPopulateSharedObjects() {
        return this.populateSharedObjects;
    }

    public void init() {
        this.populateSharedObjects = true;
    }

    public Map<String, String> getEnvVars(TaskListener listener) throws EnvInjectException {
        SharedObjectLogger logger = new SharedObjectLogger(listener);
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.populateSharedObjects) {
            logger.info("Injecting shared objects as environment variables");
            SharedObjectDataStore dataStore = new SharedObjectDataStore();
            try {
                SharedObjectType[] sharedObjectTypes = dataStore.readSharedObjectsFile();
                if (sharedObjectTypes != null) {
                    for (SharedObjectType type : sharedObjectTypes) {
                        if (type == null) continue;
                        result.put(type.getName(), type.getEnvVarValue(logger));
                    }
                }
            }
            catch (SharedObjectException se) {
                throw new EnvInjectException((Throwable)se);
            }
        }
        return result;
    }

    @Extension
    public static class SharedObjectJobPropertyDescriptor
    extends EnvInjectJobPropertyContributorDescriptor {
        public String getDisplayName() {
            return "Populate shared objects";
        }
    }
}

