/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sharedobjects;

import hudson.DescriptorExtensionList;
import hudson.Functions;
import hudson.model.Hudson;
import hudson.security.Permission;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.sharedobjects.SharedObjectsException;
import org.jenkinsci.plugins.sharedobjects.SharedObjectsType;
import org.jenkinsci.plugins.sharedobjects.service.SharedObjectsDataStore;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class SharedObjectsManagementResult {
    private SharedObjectsType[] types;

    public SharedObjectsManagementResult(SharedObjectsType[] types) {
        this.types = types;
    }

    public SharedObjectsType[] getTypes() {
        return this.types;
    }

    public DescriptorExtensionList getListSharedObjectsDescriptors() {
        return DescriptorExtensionList.createDescriptorList((Hudson)Hudson.getInstance(), SharedObjectsType.class);
    }

    public void doSaveConfig(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        JSONArray typesJSON;
        Functions.checkPermission((Permission)Hudson.ADMINISTER);
        JSONObject submittedForm = req.getSubmittedForm();
        try {
            typesJSON = submittedForm.getJSONArray("types");
        }
        catch (JSONException jsone) {
            typesJSON = submittedForm.getJSONObject("types");
        }
        List types = req.bindJSONToList(SharedObjectsType.class, (Object)typesJSON);
        SharedObjectsType[] typesArray = types.toArray(new SharedObjectsType[types.size()]);
        SharedObjectsDataStore store = new SharedObjectsDataStore();
        try {
            store.writeSharedObjectsFile(typesArray);
        }
        catch (SharedObjectsException e) {
            e.printStackTrace();
        }
        rsp.sendRedirect2("/manage");
    }
}

