/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.SemanticVersioning.parsing;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.Descriptor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.plugins.SemanticVersioning.AppVersion;
import org.jenkinsci.plugins.SemanticVersioning.InvalidBuildFileFormatException;
import org.jenkinsci.plugins.SemanticVersioning.parsing.AbstractBuildDefinitionParser;
import org.jenkinsci.plugins.SemanticVersioning.parsing.AbstractSemanticParserDescription;
import org.jenkinsci.plugins.SemanticVersioning.parsing.BuildDefinitionParser;

@Extension
public class SbtParser
extends AbstractBuildDefinitionParser {
    private static final String BUILD_DEFINITION_FILENAME = "build.sbt";

    @Override
    public AppVersion extractAppVersion(FilePath workspace, PrintStream logger) throws IOException, InvalidBuildFileFormatException {
        File file = new File(workspace + "/" + BUILD_DEFINITION_FILENAME);
        if (file.exists()) {
            String content = FileUtils.readFileToString((File)file);
            if (content == null || content.length() <= 0) {
                throw new InvalidBuildFileFormatException("'build.sbt' is not a valid SBT build definition file.");
            }
            Pattern pattern = Pattern.compile("version\\s*:=\\s*\"([^\"]*)\"", 2);
            Matcher matcher = pattern.matcher(content);
            if (!matcher.find()) {
                throw new InvalidBuildFileFormatException("No version information found in build.sbt");
            }
            String version = matcher.toMatchResult().group(1);
            SbtParser.logger.info("SbtParser::extractAppVersion => " + version);
            return AppVersion.parse(version);
        }
        throw new FileNotFoundException("'build.sbt' was not found.");
    }

    public Descriptor<BuildDefinitionParser> getDescriptor() {
        return new AbstractSemanticParserDescription(){

            @Override
            public String getDisplayName() {
                return "SBT build.sbt parser";
            }
        };
    }
}

