/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.SemanticVersioning.parsing;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.Descriptor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.plugins.SemanticVersioning.AppVersion;
import org.jenkinsci.plugins.SemanticVersioning.InvalidBuildFileFormatException;
import org.jenkinsci.plugins.SemanticVersioning.parsing.AbstractBuildDefinitionParser;
import org.jenkinsci.plugins.SemanticVersioning.parsing.AbstractSemanticParserDescription;
import org.jenkinsci.plugins.SemanticVersioning.parsing.BuildDefinitionParser;

@Extension
public class BuildScalaParser
extends AbstractBuildDefinitionParser {
    private static final String BUILD_DEFINITION_FILENAME = "/project/Build.scala";

    @Override
    public AppVersion extractAppVersion(FilePath workspace, PrintStream logger) throws InvalidBuildFileFormatException, IOException {
        String filename = workspace + BUILD_DEFINITION_FILENAME;
        File file = new File(filename);
        if (file.exists()) {
            String content;
            Pattern extendsBuild = Pattern.compile(".*extends\\s+Build.*");
            if (extendsBuild.matcher(content = FileUtils.readFileToString((File)file)).find()) {
                Pattern pattern = Pattern.compile("val\\s*appVersion\\s*=\\s*\"([^\"]*)\"", 2);
                Matcher matcher = pattern.matcher(content);
                boolean found = matcher.find();
                if (!found) {
                    throw new InvalidBuildFileFormatException("No version information found in /project/Build.scala");
                }
                String version = matcher.toMatchResult().group(1);
                return AppVersion.parse(version);
            }
            throw new InvalidBuildFileFormatException("'/project/Build.scala' is not a valid build definition file.");
        }
        throw new FileNotFoundException("'/project/Build.scala' was not found.");
    }

    public Descriptor<BuildDefinitionParser> getDescriptor() {
        return new AbstractSemanticParserDescription(){

            @Override
            public String getDisplayName() {
                return "SBT Build.scala Parser";
            }
        };
    }
}

