/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.SemanticVersioning;

import hudson.FilePath;
import hudson.remoting.Callable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import org.jenkinsci.plugins.SemanticVersioning.AppVersion;
import org.jenkinsci.plugins.SemanticVersioning.SemanticVersioningResult;
import org.jenkinsci.plugins.SemanticVersioning.naming.NamingStrategy;
import org.jenkinsci.plugins.SemanticVersioning.parsing.BuildDefinitionParser;
import org.jenkinsci.remoting.RoleChecker;

public class SemanticVersioningCallable
implements Callable<SemanticVersioningResult, IOException>,
Serializable {
    private static final long serialVersionUID = -2239554739563636620L;
    private String env;
    private boolean useBuildNumber;
    private FilePath workspace;
    private int buildNumber;
    private BuildDefinitionParser parser;
    private NamingStrategy namingStrategy;

    public void checkRoles(RoleChecker arg0) throws SecurityException {
    }

    public SemanticVersioningResult call() throws IOException {
        SemanticVersioningResult out = new SemanticVersioningResult();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream((OutputStream)baos, true, "utf-8");
        ps.println("executing on " + InetAddress.getLocalHost().getHostName());
        try {
            HashMap<String, String> vars;
            AppVersion appVersion = AppVersion.EmptyVersion;
            try {
                appVersion = this.getAppVersion(ps);
                ps.println("exporting vars ... ");
                vars = new HashMap<String, String>();
                String v = this.namingStrategy.exportNames(appVersion, vars, this.useBuildNumber, this.buildNumber);
                out.setVersion(v);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            vars = new HashMap();
            this.namingStrategy.exportNames(appVersion, vars, this.useBuildNumber, this.buildNumber);
            out.setVars(vars);
        }
        catch (Exception e) {
            e.printStackTrace(ps);
        }
        ps.flush();
        baos.flush();
        ArrayList<String> log = new ArrayList<String>();
        for (String l : new String(baos.toByteArray(), "utf-8").split("[\\r\\n]+")) {
            log.add(l);
        }
        out.setLog(log);
        return out;
    }

    private AppVersion getAppVersion(PrintStream log) throws IOException {
        AppVersion appVersion = AppVersion.EmptyVersion;
        if (this.parser != null) {
            try {
                appVersion = this.parser.extractAppVersion(this.getWorkspace(), log);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return appVersion;
    }

    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public BuildDefinitionParser getParser() {
        return this.parser;
    }

    public void setParser(BuildDefinitionParser parser) {
        this.parser = parser;
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(NamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public boolean isUseBuildNumber() {
        return this.useBuildNumber;
    }

    public void setUseBuildNumber(boolean useBuildNumber) {
        this.useBuildNumber = useBuildNumber;
    }

    public FilePath getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(FilePath workspace) {
        this.workspace = workspace;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(int buildNumber) {
        this.buildNumber = buildNumber;
    }
}

