/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.SemanticVersioning;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.util.ListBoxModel;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import java.io.IOException;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.SemanticVersioning.AppVersion;
import org.jenkinsci.plugins.SemanticVersioning.columnDisplay.AbstractColumnDisplayStrategy;
import org.jenkinsci.plugins.SemanticVersioning.columnDisplay.ColumnDisplayStrategy;
import org.jenkinsci.plugins.SemanticVersioning.columnDisplay.LastSuccessfulBuildStrategy;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class SemanticVersionColumn
extends ListViewColumn {
    private static Logger logger = Logger.getLogger(String.valueOf(AppVersion.class));
    private ColumnDisplayStrategy displayStrategy;
    public static final Descriptor<ListViewColumn> descriptor = new SemanticVersionColumnDescriptor();

    @DataBoundConstructor
    public SemanticVersionColumn(String displayStrategyName) {
        try {
            this.displayStrategy = (ColumnDisplayStrategy)Jenkins.getActiveInstance().getExtensionList(displayStrategyName).iterator().next();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public String getDisplayStrategy() {
        return this.displayStrategy.getClass().getCanonicalName();
    }

    public String getSemanticVersion(Job job) throws IOException, InterruptedException {
        if (job == null || job.getLastBuild() == null || job.getLastBuild().getResult() == null) {
            return "-";
        }
        ColumnDisplayStrategy strategy = job.getLastBuild().getResult().ordinal == 0 ? new LastSuccessfulBuildStrategy() : this.displayStrategy;
        return strategy.getDisplayString(job);
    }

    @Extension(ordinal=1.5)
    public static class SemanticVersionColumnDescriptor
    extends ListViewColumnDescriptor {
        public boolean shownByDefault() {
            return false;
        }

        public ListViewColumn newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String strategy = formData == null ? null : formData.optString("displayStrategy");
            return new SemanticVersionColumn(StringUtils.defaultIfBlank((String)strategy, (String)LastSuccessfulBuildStrategy.class.getCanonicalName()));
        }

        public ListBoxModel doFillDisplayStrategyItems() {
            ListBoxModel columnDisplayStrategies = new ListBoxModel();
            ExtensionList<ColumnDisplayStrategy> extensionList = AbstractColumnDisplayStrategy.getStrategies();
            logger.info("SemanticVersionColumnDescriptor::doFillDisplayStrategyItems There are " + extensionList.size() + " strategies available.");
            for (ColumnDisplayStrategy strategy : extensionList) {
                columnDisplayStrategies.add(strategy.getDescriptor().getDisplayName(), strategy.getClass().getCanonicalName());
            }
            return columnDisplayStrategies;
        }

        public String getDisplayName() {
            return "Semantic Version";
        }
    }
}

