/*
 * Decompiled with CFR 0.152.
 */
package il.ac.technion.jenkins.plugins;

import hudson.Extension;
import hudson.model.Hudson;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.SimpleParameterDefinition;
import hudson.model.StringParameterValue;
import hudson.util.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class TestExecuter
extends SimpleParameterDefinition {
    private final String uuid = UUID.randomUUID().toString();
    private final String propertiesFilePath;
    private final OverrideSettingBlock enableField;
    private final OverrideSettingBlock groupBy;
    private final OverrideSettingBlock fieldSeparator;
    private final OverrideSettingBlock showFields;
    private final OverrideSettingBlock multiplicityField;

    @DataBoundConstructor
    public TestExecuter(String name, String description, String propertiesFilePath, OverrideSettingBlock enableField, OverrideSettingBlock groupBy, OverrideSettingBlock fieldSeparator, OverrideSettingBlock showFields, OverrideSettingBlock multiplicityField) {
        super(name, description);
        this.propertiesFilePath = propertiesFilePath;
        this.enableField = enableField;
        this.groupBy = groupBy;
        this.fieldSeparator = fieldSeparator;
        this.showFields = showFields;
        this.multiplicityField = multiplicityField;
    }

    public String getAsJson() {
        return "{enableField:" + (this.enableField == null ? "null" : '\"' + this.enableField.text + '\"') + ",groupBy:" + (this.groupBy == null ? "null" : '\"' + this.groupBy.text + '\"') + ",fieldSeparator:" + (this.fieldSeparator == null ? "null" : '\"' + this.fieldSeparator.text + '\"') + ",showFields:" + (this.showFields == null ? "null" : '\"' + this.showFields.text + '\"') + ",multiplicityField:" + (this.multiplicityField == null ? "null" : '\"' + this.multiplicityField.text + '\"') + "}";
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getPropertiesFilePath() {
        return this.propertiesFilePath;
    }

    public OverrideSettingBlock getEnableField() {
        return this.enableField;
    }

    public OverrideSettingBlock getGroupBy() {
        return this.groupBy;
    }

    public OverrideSettingBlock getFieldSeparator() {
        return this.fieldSeparator;
    }

    public OverrideSettingBlock getShowFields() {
        return this.showFields;
    }

    public OverrideSettingBlock getMultiplicityField() {
        return this.multiplicityField;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Hudson.getInstance().getDescriptor(((Object)((Object)this)).getClass());
    }

    public ParameterValue createValue(String value) {
        return new StringParameterValue(this.getName(), value, this.getDescription());
    }

    public ParameterValue createValue(StaplerRequest req, JSONObject jo) {
        return this.createValue(jo.getString("selectedTests"));
    }

    @JavaScriptMethod
    public ReadFileResponse loadPropertiesFile(String filePath) {
        return DescriptorImpl.loadPropertiesFile(filePath);
    }

    @Extension
    public static final class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public String getDisplayName() {
            return "Choosing Tests";
        }

        @JavaScriptMethod
        public static ReadFileResponse loadPropertiesFile(String filePath) {
            if (filePath == null || filePath.isEmpty()) {
                return new ReadFileResponse(false, "Invalid file name", null);
            }
            File file = new File(filePath);
            if (!file.exists()) {
                return new ReadFileResponse(false, "File doesn't exist OR Jenkins doesn't have permission for this file", null);
            }
            if (!file.isFile()) {
                return new ReadFileResponse(false, "Not a file", null);
            }
            try {
                FileInputStream inputStream = new FileInputStream(file.getPath());
                return new ReadFileResponse(true, null, IOUtils.toString((InputStream)inputStream, (String)"UTF-8"));
            }
            catch (IOException e) {
                return new ReadFileResponse(false, "Could not access file: " + e.getMessage(), null);
            }
        }
    }

    public static class ReadFileResponse {
        public boolean success;
        public String errorMsg;
        public String content;

        public ReadFileResponse(boolean success, String errorMsg, String content) {
            this.success = success;
            this.errorMsg = errorMsg;
            this.content = content;
        }
    }

    public static class OverrideSettingBlock {
        public final String text;

        @DataBoundConstructor
        public OverrideSettingBlock(String text) {
            this.text = text;
        }
    }
}

