/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptler;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Plugin;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.security.PermissionScope;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.plugins.scriptler.Messages;
import org.jenkinsci.plugins.scriptler.ScriptlerManagement;
import org.jenkinsci.plugins.scriptler.SyncUtil;
import org.jenkinsci.plugins.scriptler.config.Script;
import org.jenkinsci.plugins.scriptler.config.ScriptlerConfiguration;
import org.jenkinsci.plugins.scriptler.util.ScriptHelper;

public class ScriptlerPluginImpl
extends Plugin {
    private static final Logger LOGGER = Logger.getLogger(ScriptlerPluginImpl.class.getName());
    public static final PermissionGroup SCRIPTLER_PERMISSIONS = new PermissionGroup(ScriptlerManagement.class, Messages._permissons_title());
    public static final Permission CONFIGURE = new Permission(SCRIPTLER_PERMISSIONS, "Configure", Messages._permissons_configure_description(), Jenkins.RUN_SCRIPTS, PermissionScope.JENKINS);
    public static final Permission RUN_SCRIPTS = new Permission(SCRIPTLER_PERMISSIONS, "RunScripts", Messages._permissons_runScript_description(), Jenkins.RUN_SCRIPTS, PermissionScope.JENKINS);

    public void start() throws Exception {
        super.start();
        this.synchronizeConfig();
    }

    private void synchronizeConfig() throws IOException {
        boolean dirsDone;
        LOGGER.info("initialize Scriptler");
        if (!ScriptlerManagement.getScriptlerHomeDirectory().exists() && !(dirsDone = ScriptlerManagement.getScriptlerHomeDirectory().mkdirs())) {
            LOGGER.severe("could not create Scriptler home directory: " + ScriptlerManagement.getScriptlerHomeDirectory());
        }
        File scriptDirectory = ScriptlerManagement.getScriptDirectory();
        this.createMissingFolders(scriptDirectory);
        ScriptlerConfiguration cfg = ScriptlerConfiguration.load();
        SyncUtil.syncDirWithCfg(scriptDirectory, cfg);
        cfg.save();
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    private void createMissingFolders(File folder) {
        if (!folder.exists()) {
            folder.mkdirs();
        }
    }

    @Initializer(after=InitMilestone.JOB_LOADED)
    public static void afterJobLoaded() throws Exception {
        ScriptlerPluginImpl.setupExistingScripts();
    }

    private static void setupExistingScripts() throws Exception {
        for (Script script : ScriptlerConfiguration.getConfiguration().getScripts()) {
            File scriptFile = new File(ScriptlerManagement.getScriptDirectory(), script.getScriptPath());
            try {
                String scriptSource = FileUtils.readFileToString((File)scriptFile, (String)"UTF-8");
                ScriptHelper.putScriptInApprovalQueueIfRequired(scriptSource);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Source file for the script [{0}] was not found", script.getId());
            }
        }
    }
}

