/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptler;

import hudson.Extension;
import hudson.PluginWrapper;
import hudson.Util;
import hudson.markup.MarkupFormatter;
import hudson.markup.RawHtmlMarkupFormatter;
import hudson.model.Computer;
import hudson.model.Failure;
import hudson.model.ManagementLink;
import hudson.model.RootAction;
import hudson.security.Permission;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jenkins.model.Jenkins;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.scriptler.Messages;
import org.jenkinsci.plugins.scriptler.ScriptlerPluginImpl;
import org.jenkinsci.plugins.scriptler.config.Parameter;
import org.jenkinsci.plugins.scriptler.config.Script;
import org.jenkinsci.plugins.scriptler.config.ScriptlerConfiguration;
import org.jenkinsci.plugins.scriptler.git.GitScriptlerRepository;
import org.jenkinsci.plugins.scriptler.share.CatalogInfo;
import org.jenkinsci.plugins.scriptler.share.ScriptInfo;
import org.jenkinsci.plugins.scriptler.share.ScriptInfoCatalog;
import org.jenkinsci.plugins.scriptler.util.ScriptHelper;
import org.jenkinsci.plugins.scriptler.util.UIHelper;
import org.kohsuke.stapler.ForwardToView;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class ScriptlerManagement
extends ManagementLink
implements RootAction {
    private static final Logger LOGGER = Logger.getLogger(ScriptlerManagement.class.getName());
    private static final String MASTER = "(master)";
    private static final String ALL = "(all)";
    private static final String ALL_SLAVES = "(all slaves)";
    private static final MarkupFormatter INSTANCE = RawHtmlMarkupFormatter.INSTANCE;

    public Permission getScriptlerRunScripts() {
        return ScriptlerPluginImpl.RUN_SCRIPTS;
    }

    public Permission getScriptlerConfigure() {
        return ScriptlerPluginImpl.CONFIGURE;
    }

    public boolean hasAtLeastOneScriptlerPermission() {
        return Jenkins.getInstance().hasPermission(ScriptlerPluginImpl.RUN_SCRIPTS) || Jenkins.getInstance().hasPermission(ScriptlerPluginImpl.CONFIGURE);
    }

    public void checkAtLeastOneScriptlerPermission() {
        if (!Jenkins.getInstance().hasPermission(ScriptlerPluginImpl.RUN_SCRIPTS)) {
            Jenkins.getInstance().checkPermission(ScriptlerPluginImpl.CONFIGURE);
        }
    }

    public String getIconFileName() {
        return this.hasAtLeastOneScriptlerPermission() ? "notepad.gif" : null;
    }

    public String getUrlName() {
        return "scriptler";
    }

    public boolean disableRemoteCatalog() {
        return this.getConfiguration().isDisbableRemoteCatalog();
    }

    public String getDisplayName() {
        return Messages.display_name();
    }

    public String getDescription() {
        return Messages.description();
    }

    public ScriptlerManagement getScriptler() {
        return this;
    }

    public ScriptlerConfiguration getConfiguration() {
        return ScriptlerConfiguration.getConfiguration();
    }

    public MarkupFormatter getMarkupFormatter() {
        return INSTANCE;
    }

    public String getPluginResourcePath() {
        PluginWrapper wrapper = Jenkins.getInstance().getPluginManager().getPlugin(ScriptlerPluginImpl.class);
        return Jenkins.getInstance().getRootUrl() + "plugin/" + wrapper.getShortName() + "/";
    }

    @RequirePOST
    public HttpResponse doScriptlerSettings(StaplerRequest res, StaplerResponse rsp, @QueryParameter(value="disableRemoteCatalog") boolean disableRemoteCatalog) throws IOException {
        this.checkPermission(ScriptlerPluginImpl.CONFIGURE);
        ScriptlerConfiguration cfg = this.getConfiguration();
        cfg.setDisbableRemoteCatalog(disableRemoteCatalog);
        cfg.save();
        return new HttpRedirect("settings");
    }

    @RequirePOST
    public HttpResponse doDownloadScript(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="id") String id, @QueryParameter(value="catalog") String catalogName) throws IOException, ServletException {
        this.checkPermission(ScriptlerPluginImpl.CONFIGURE);
        ScriptlerConfiguration c = this.getConfiguration();
        if (c.isDisbableRemoteCatalog()) {
            return new HttpRedirect("index");
        }
        for (ScriptInfoCatalog scriptInfoCatalog : ScriptInfoCatalog.all()) {
            if (!catalogName.equals(scriptInfoCatalog.getInfo().name)) continue;
            Object info = scriptInfoCatalog.getEntryById(id);
            String source = scriptInfoCatalog.getScriptSource(info);
            ArrayList<Parameter> paramList = new ArrayList<Parameter>();
            for (String paramName : ((ScriptInfo)info).getParameters()) {
                paramList.add(new Parameter(paramName, null));
            }
            Parameter[] parameters = paramList.toArray(new Parameter[paramList.size()]);
            String finalName = this.saveScriptAndForward(id, ((ScriptInfo)info).getName(), ((ScriptInfo)info).getComment(), source, false, false, catalogName, id, parameters);
            return new HttpRedirect("editScript?id=" + finalName);
        }
        ForwardToView view = new ForwardToView((Object)this, "catalog.jelly");
        view.with("message", (Object)Messages.download_failed(id, catalogName));
        view.with("catName", (Object)catalogName);
        return view;
    }

    @RequirePOST
    public HttpResponse doScriptAdd(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="id") String id, @QueryParameter(value="name") String name, @QueryParameter(value="comment") String comment, @QueryParameter(value="script") String script, @QueryParameter(value="nonAdministerUsing") boolean nonAdministerUsing, @QueryParameter(value="onlyMaster") boolean onlyMaster, String originCatalogName, String originId) throws IOException, ServletException {
        this.checkPermission(ScriptlerPluginImpl.CONFIGURE);
        Parameter[] parameters = UIHelper.extractParameters(req.getSubmittedForm());
        this.saveScriptAndForward(id, name, comment, script, nonAdministerUsing, onlyMaster, originCatalogName, originId, parameters);
        return new HttpRedirect("index");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String saveScriptAndForward(String id, String name, String comment, String script, boolean nonAdministerUsing, boolean onlyMaster, String originCatalogName, String originId, Parameter[] parameters) throws IOException {
        String string = script = script == null ? "TODO" : script;
        if (StringUtils.isEmpty((String)id)) {
            throw new IllegalArgumentException("'id' must not be empty!");
        }
        String displayName = name == null ? id : name;
        String finalFileName = this.fixFileName(originCatalogName, id);
        File newScriptFile = new File(ScriptlerManagement.getScriptDirectory(), finalFileName);
        if (!Util.isDescendant((File)ScriptlerManagement.getScriptDirectory(), (File)new File(ScriptlerManagement.getScriptDirectory(), finalFileName))) {
            LOGGER.log(Level.WARNING, "Folder traversal detected, file path received: {0}, after fixing: {1}", new Object[]{id, finalFileName});
            throw new IOException("Invalid file path received: " + id);
        }
        try (FileWriter writer = new FileWriter(newScriptFile);){
            writer.write(script);
        }
        this.commitFileToGitRepo(finalFileName);
        ScriptHelper.putScriptInApprovalQueueIfRequired(script);
        Script newScript = null;
        newScript = !StringUtils.isEmpty((String)originId) ? new Script(finalFileName, displayName, comment, true, originCatalogName, originId, new SimpleDateFormat("dd MMM yyyy HH:mm:ss a").format(new Date()), parameters) : new Script(finalFileName, displayName, comment, nonAdministerUsing, parameters, onlyMaster);
        ScriptlerConfiguration cfg = this.getConfiguration();
        cfg.addOrReplace(newScript);
        cfg.save();
        return finalFileName;
    }

    private void commitFileToGitRepo(String finalFileName) throws IOException {
        try {
            this.getGitRepo().addSingleFileToRepo(finalFileName);
        }
        catch (Exception e) {
            throw new IOException("failed to update git repo", e);
        }
    }

    private GitScriptlerRepository getGitRepo() {
        return (GitScriptlerRepository)((Object)Jenkins.getInstance().getExtensionList(GitScriptlerRepository.class).get(GitScriptlerRepository.class));
    }

    @RequirePOST
    public HttpResponse doHardResetGit() throws IOException {
        this.checkPermission(ScriptlerPluginImpl.CONFIGURE);
        this.getGitRepo().hardReset();
        return new HttpRedirect("../scriptler.git");
    }

    @RequirePOST
    public HttpResponse doRemoveScript(StaplerRequest res, StaplerResponse rsp, @QueryParameter(value="id") String id) throws IOException {
        this.checkPermission(ScriptlerPluginImpl.CONFIGURE);
        File oldScript = new File(ScriptlerManagement.getScriptDirectory(), id);
        if (!oldScript.delete() && oldScript.exists()) {
            throw new Failure("not able to delete " + oldScript.getAbsolutePath());
        }
        try {
            GitScriptlerRepository gitRepo = (GitScriptlerRepository)((Object)Jenkins.getInstance().getExtensionList(GitScriptlerRepository.class).get(GitScriptlerRepository.class));
            gitRepo.rmSingleFileToRepo(id);
        }
        catch (Exception e) {
            throw new IOException("failed to update git repo", e);
        }
        ScriptlerConfiguration cfg = this.getConfiguration();
        cfg.removeScript(id);
        cfg.save();
        return new HttpRedirect("index");
    }

    @RequirePOST
    public HttpResponse doUploadScript(StaplerRequest req) throws IOException, ServletException {
        this.checkPermission(ScriptlerPluginImpl.CONFIGURE);
        try {
            FileItem fileItem = req.getFileItem("file");
            boolean nonAdministerUsing = req.getSubmittedForm().getBoolean("nonAdministerUsing");
            String fileName = Util.getFileName((String)fileItem.getName());
            if (StringUtils.isEmpty((String)fileName)) {
                return new HttpRedirect(".");
            }
            this.saveScript(fileItem, nonAdministerUsing, fileName);
            return new HttpRedirect("index");
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    void saveScript(FileItem fileItem, boolean nonAdministerUsing, String fileName) throws Exception, IOException {
        String fixedFileName = this.fixFileName(null, fileName);
        File fixedFile = new File(fixedFileName);
        if (fixedFile.isAbsolute()) {
            LOGGER.log(Level.WARNING, "Folder traversal detected, file path received: {0}, after fixing: {1}. Seems to be an attempt to use absolute path instead of relative one", new Object[]{fileName, fixedFileName});
            throw new IOException("Invalid file path received: " + fileName);
        }
        File rootDir = ScriptlerManagement.getScriptDirectory();
        File f = new File(rootDir, fixedFileName);
        if (!Util.isDescendant((File)rootDir, (File)new File(rootDir, fixedFileName))) {
            LOGGER.log(Level.WARNING, "Folder traversal detected, file path received: {0}, after fixing: {1}. Seems to be an attempt to use folder escape.", new Object[]{fileName, fixedFileName});
            throw new IOException("Invalid file path received: " + fileName);
        }
        fileItem.write(f);
        this.commitFileToGitRepo(fixedFileName);
        Script script = ScriptHelper.getScript(fixedFileName, false);
        if (script == null) {
            script = new Script(fixedFileName, fixedFileName, true, nonAdministerUsing, false);
        }
        String scriptSource = FileUtils.readFileToString((File)f, (String)"UTF-8");
        ScriptHelper.putScriptInApprovalQueueIfRequired(scriptSource);
        ScriptlerConfiguration config = this.getConfiguration();
        config.addOrReplace(script);
    }

    public void doRunScript(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="id") String id) throws IOException, ServletException {
        this.checkPermission(ScriptlerPluginImpl.RUN_SCRIPTS);
        Script script = ScriptHelper.getScript(id, true);
        if (script == null) {
            throw new IOException(Messages.scriptNotFound(id));
        }
        if (script.script == null) {
            req.setAttribute("scriptNotFound", (Object)true);
        } else {
            boolean canByPassScriptApproval = Jenkins.getInstance().hasPermission(Jenkins.RUN_SCRIPTS);
            if (!ScriptHelper.isApproved(script.script, false)) {
                req.setAttribute("notApprovedYet", (Object)true);
            }
            req.setAttribute("canByPassScriptApproval", (Object)canByPassScriptApproval);
        }
        req.setAttribute("script", (Object)script);
        req.setAttribute("currentNode", (Object)MASTER);
        req.getView((Object)this, "runScript.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    @RequirePOST
    public void doTriggerScript(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="id") String id, @QueryParameter(value="script") String scriptSrc, @QueryParameter(value="node") String node) throws IOException, ServletException {
        String output;
        this.checkPermission(ScriptlerPluginImpl.RUN_SCRIPTS);
        Parameter[] parameters = UIHelper.extractParameters(req.getSubmittedForm());
        boolean canByPassScriptApproval = Jenkins.getInstance().hasPermission(Jenkins.RUN_SCRIPTS);
        Script originalScript = ScriptHelper.getScript(id, true);
        if (originalScript == null) {
            rsp.sendError(404, "No script found for id=" + id);
            return;
        }
        String originalScriptSourceCode = originalScript.script;
        Script tempScript = originalScript.copy();
        if (originalScriptSourceCode != null && originalScriptSourceCode.equals(scriptSrc)) {
            tempScript.setScript(originalScriptSourceCode);
        } else {
            tempScript.setScript(scriptSrc);
            ScriptHelper.putScriptInApprovalQueueIfRequired(scriptSrc);
        }
        if (ScriptHelper.isApproved(scriptSrc)) {
            String[] slaves = this.resolveSlaveNames(node);
            output = ScriptHelper.runScript(slaves, scriptSrc, parameters);
        } else {
            LOGGER.log(Level.WARNING, "Script {0} was not approved yet, consider asking your administrator to approve it.", id);
            output = null;
            req.setAttribute("notApprovedYet", (Object)true);
        }
        tempScript.setParameters(parameters);
        req.setAttribute("script", (Object)tempScript);
        req.setAttribute("currentNode", (Object)node);
        req.setAttribute("output", (Object)output);
        req.setAttribute("canByPassScriptApproval", (Object)canByPassScriptApproval);
        req.getView((Object)this, "runScript.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    @RequirePOST
    public void doRun(StaplerRequest req, StaplerResponse rsp, @QueryParameter(fixEmpty=true) String script, @QueryParameter(fixEmpty=true) String node, @QueryParameter(fixEmpty=true) String contentType) throws IOException, ServletException {
        this.checkPermission(ScriptlerPluginImpl.RUN_SCRIPTS);
        String id = req.getRestOfPath();
        if (id.startsWith("/")) {
            id = id.substring(1);
        }
        if (StringUtils.isEmpty((String)id)) {
            throw new RuntimeException("Please specify a script id. Use /scriptler/run/<yourScriptId>");
        }
        Script tempScript = ScriptHelper.getScript(id, true);
        if (tempScript == null) {
            throw new RuntimeException("Unknown script: " + id + ". Use /scriptler/run/<yourScriptId>");
        }
        if (script == null) {
            script = tempScript.script;
        }
        if (!ScriptHelper.isApproved(script)) {
            LOGGER.log(Level.WARNING, "Script {0} was not approved yet, consider asking your administrator to approve it.", id);
            rsp.sendError(403, "Script not approved yet, consider asking your administrator to approve it.");
            return;
        }
        Parameter[] paramArray = this.prepareParameters(req, tempScript);
        rsp.setContentType(contentType == null ? "text/plain" : contentType);
        String[] slaves = this.resolveSlaveNames(node == null ? MASTER : node);
        if (slaves.length > 1) {
            rsp.getOutputStream().print(ScriptHelper.runScript(slaves, script, paramArray));
        } else {
            rsp.getOutputStream().print(ScriptHelper.runScript(slaves[0], script, paramArray));
        }
    }

    private Parameter[] prepareParameters(StaplerRequest req, Script tempScript) {
        HashMap<String, Parameter> params = new HashMap<String, Parameter>();
        for (Parameter param : tempScript.getParameters()) {
            params.put(param.getName(), param);
        }
        for (Map.Entry entry : req.getParameterMap().entrySet()) {
            if (!params.containsKey(entry.getKey())) continue;
            params.put((String)entry.getKey(), new Parameter((String)entry.getKey(), ((String[])entry.getValue())[0]));
        }
        Parameter[] paramArray = params.values().toArray(new Parameter[params.size()]);
        return paramArray;
    }

    private String[] resolveSlaveNames(String nameAlias) {
        List<String> slaves = null;
        if (nameAlias.equalsIgnoreCase(ALL) || nameAlias.equalsIgnoreCase(ALL_SLAVES)) {
            slaves = this.getSlaveNames();
            if (nameAlias.equalsIgnoreCase(ALL) && !slaves.contains(MASTER)) {
                slaves.add(MASTER);
            }
            if (nameAlias.equalsIgnoreCase(ALL_SLAVES)) {
                slaves.remove(MASTER);
            }
        } else {
            slaves = Arrays.asList(nameAlias);
        }
        return slaves.toArray(new String[slaves.size()]);
    }

    public void doShowScript(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="id") String id) throws IOException, ServletException {
        Script script = ScriptHelper.getScript(id, true);
        req.setAttribute("script", (Object)script);
        req.getView((Object)this, "show.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    public void doEditScript(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="id") String id) throws IOException, ServletException {
        this.checkPermission(ScriptlerPluginImpl.CONFIGURE);
        Script script = ScriptHelper.getScript(id, true);
        if (script.script == null) {
            req.setAttribute("scriptNotFound", (Object)true);
        } else {
            boolean canByPassScriptApproval = Jenkins.getInstance().hasPermission(Jenkins.RUN_SCRIPTS);
            if (!ScriptHelper.isApproved(script.script, false)) {
                req.setAttribute("notApprovedYet", (Object)true);
            }
            req.setAttribute("canByPassScriptApproval", (Object)canByPassScriptApproval);
        }
        req.setAttribute("script", (Object)script);
        req.getView((Object)this, "edit.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    public List<String> getSlaveAlias(Script script) {
        if (script.onlyMaster) {
            ArrayList<String> slaveNames = new ArrayList<String>();
            slaveNames.add(MASTER);
            return slaveNames;
        }
        List<String> slaveNames = this.getSlaveNames();
        if (!slaveNames.contains(MASTER)) {
            slaveNames.add(0, MASTER);
        }
        if (slaveNames.size() > 0) {
            if (!slaveNames.contains(ALL)) {
                slaveNames.add(1, ALL);
            }
            if (!slaveNames.contains(ALL_SLAVES)) {
                slaveNames.add(2, ALL_SLAVES);
            }
        }
        return slaveNames;
    }

    private List<String> getSlaveNames() {
        Computer[] computers = Jenkins.getInstance().getComputers();
        ArrayList<String> slaves = new ArrayList<String>();
        for (Computer c : computers) {
            slaves.add(c.getName());
        }
        return slaves;
    }

    public List<ScriptInfoCatalog> getCatalogs() {
        return ScriptInfoCatalog.all();
    }

    public ScriptInfoCatalog<? extends ScriptInfo> getCatalogByName(String catalogName) {
        if (StringUtils.isNotBlank((String)catalogName)) {
            for (ScriptInfoCatalog sic : this.getCatalogs()) {
                CatalogInfo info = sic.getInfo();
                if (!catalogName.equals(info.name)) continue;
                return sic;
            }
        }
        return null;
    }

    public CatalogInfo getCatalogInfoByName(String catalogName) {
        if (StringUtils.isNotBlank((String)catalogName)) {
            for (ScriptInfoCatalog sic : this.getCatalogs()) {
                CatalogInfo info = sic.getInfo();
                if (!catalogName.equals(info.name)) continue;
                return info;
            }
        }
        return null;
    }

    public static File getScriptDirectory() {
        return new File(ScriptlerManagement.getScriptlerHomeDirectory(), "scripts");
    }

    public static File getScriptlerHomeDirectory() {
        return new File(Jenkins.getInstance().getRootDir(), "scriptler");
    }

    private void checkPermission(Permission permission) {
        Jenkins.getInstance().checkPermission(permission);
    }

    private String fixFileName(String catalogName, String name) {
        if (!name.endsWith(".groovy")) {
            if (!StringUtils.isEmpty((String)catalogName)) {
                name = name + "." + catalogName;
            }
            name = name + ".groovy";
        }
        name = name.replace(" ", "_").trim();
        LOGGER.fine("set file name to: " + name);
        return name;
    }
}

