/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptler.config;

import com.thoughtworks.xstream.XStream;
import hudson.BulkChange;
import hudson.XmlFile;
import hudson.model.Saveable;
import hudson.model.listeners.SaveableListener;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.scriptler.ScriptlerManagement;
import org.jenkinsci.plugins.scriptler.config.NamedResource;
import org.jenkinsci.plugins.scriptler.config.Parameter;
import org.jenkinsci.plugins.scriptler.config.Script;
import org.jenkinsci.plugins.scriptler.config.ScriptSet;
import org.jenkinsci.plugins.scriptler.share.CatalogInfo;
import org.jenkinsci.plugins.scriptler.util.ByIdSorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScriptlerConfiguration
extends ScriptSet
implements Saveable {
    private static final Logger LOGGER = Logger.getLogger(ScriptlerConfiguration.class.getName());
    @Deprecated
    private transient List<CatalogInfo> catalogInfos = new ArrayList<CatalogInfo>();
    private boolean disbableRemoteCatalog = false;
    private boolean allowRunScriptPermission = false;
    private boolean allowRunScriptEdit = false;
    private static transient ScriptlerConfiguration cfg = null;
    private static final XStream XSTREAM = new XStream2();

    public ScriptlerConfiguration(SortedSet<Script> scripts) {
        if (scripts != null) {
            this.scriptSet = scripts;
        }
    }

    public synchronized void save() throws IOException {
        if (BulkChange.contains((Saveable)this)) {
            return;
        }
        ScriptlerConfiguration.getXmlFile().write((Object)this);
        SaveableListener.fireOnChange((Saveable)this, (XmlFile)ScriptlerConfiguration.getXmlFile());
    }

    public static XmlFile getXmlFile() {
        return new XmlFile(XSTREAM, new File(ScriptlerManagement.getScriptlerHomeDirectory(), "scriptler.xml"));
    }

    public static ScriptlerConfiguration load() throws IOException {
        XmlFile f = ScriptlerConfiguration.getXmlFile();
        if (f.exists()) {
            ScriptlerConfiguration sc = (ScriptlerConfiguration)f.read();
            TreeSet<NamedResource> sorted = new TreeSet<NamedResource>(new ByIdSorter());
            sorted.addAll(sc.getScripts());
            sc.setScripts(sorted);
            return sc;
        }
        return null;
    }

    public static ScriptlerConfiguration getConfiguration() {
        if (cfg == null) {
            try {
                cfg = ScriptlerConfiguration.load();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Failed to load scriptler configuration", e);
            }
        }
        return cfg;
    }

    public boolean isDisbableRemoteCatalog() {
        return this.disbableRemoteCatalog;
    }

    public void setDisbableRemoteCatalog(boolean disbableRemoteCatalog) {
        this.disbableRemoteCatalog = disbableRemoteCatalog;
    }

    public void setAllowRunScriptEdit(boolean allowRunScriptEdit) {
        this.allowRunScriptEdit = allowRunScriptEdit;
    }

    public void setAllowRunScriptPermission(boolean allowRunScriptPermission) {
        this.allowRunScriptPermission = allowRunScriptPermission;
    }

    public boolean isAllowRunScriptEdit() {
        return this.allowRunScriptEdit;
    }

    public boolean isAllowRunScriptPermission() {
        return this.allowRunScriptPermission;
    }

    static {
        XSTREAM.alias("scriptler", ScriptlerConfiguration.class);
        XSTREAM.alias("script", Script.class);
        XSTREAM.alias("catalog", CatalogInfo.class);
        XSTREAM.alias("parameter", Parameter.class);
        XSTREAM.alias("org.jvnet.hudson.plugins.scriptler.util.ByNameSorter", ByIdSorter.class);
    }
}

