/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptler.config;

import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.scriptler.config.Script;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptSet {
    protected Set<Script> scriptSet = new TreeSet<Script>();

    public Script getScriptById(String id) {
        for (Script scr : this.scriptSet) {
            if (!scr.getId().equals(id)) continue;
            return scr;
        }
        return null;
    }

    public void removeScript(String id) {
        Script s = this.getScriptById(id);
        this.scriptSet.remove(s);
    }

    public void addOrReplace(Script script) {
        if (script != null) {
            Script oldScript = this.getScriptById(script.getId());
            if (oldScript != null) {
                Script mergedScript = this.merge(oldScript, script);
                this.scriptSet.remove(script);
                this.scriptSet.add(mergedScript);
            } else {
                this.scriptSet.add(script);
            }
        }
    }

    private Script merge(Script origin, Script newScript) {
        String name = StringUtils.isEmpty((String)newScript.name) ? origin.name : newScript.name;
        String comment = StringUtils.isEmpty((String)newScript.comment) ? origin.comment : newScript.comment;
        String originCatalog = StringUtils.isEmpty((String)newScript.originCatalog) ? origin.originCatalog : newScript.originCatalog;
        String originScript = StringUtils.isEmpty((String)newScript.originScript) ? origin.originScript : newScript.originScript;
        String originDate = StringUtils.isEmpty((String)newScript.originDate) ? origin.originDate : newScript.originDate;
        return new Script(newScript.getId(), name, comment, newScript.available, originCatalog, originScript, originDate, newScript.nonAdministerUsing, newScript.getParameters());
    }

    public final Set<Script> getScripts() {
        return Collections.unmodifiableSet(this.scriptSet);
    }

    public final Set<Script> getUserScripts() {
        TreeSet<Script> userScripts = new TreeSet<Script>();
        for (Script script : this.scriptSet) {
            if (!script.nonAdministerUsing) continue;
            userScripts.add(script);
        }
        return userScripts;
    }

    public void setScripts(Set<Script> scripts) {
        this.scriptSet = scripts;
    }
}

