/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api;

import com.google.common.net.InternetDomainName;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.IDN;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public final class SCMName {
    private SCMName() {
        throw new IllegalAccessError("Utility class");
    }

    @CheckForNull
    public static String fromUrl(@NonNull String url, String ... ignoredPrefixes) {
        try {
            return SCMName.innerFromUrl(url, ignoredPrefixes.length == 0 ? null : Arrays.asList(ignoredPrefixes));
        }
        catch (LinkageError e) {
            return null;
        }
    }

    @CheckForNull
    public static String fromUrl(@NonNull String url, @CheckForNull List<String> ignoredPrefixes) {
        try {
            return SCMName.innerFromUrl(url, ignoredPrefixes);
        }
        catch (LinkageError e) {
            return null;
        }
    }

    @CheckForNull
    private static String innerFromUrl(@NonNull String url, @CheckForNull List<String> ignoredPrefixes) throws LinkageError {
        String hostName;
        try {
            URL serverUri = new URL(url);
            hostName = serverUri.getHost();
        }
        catch (MalformedURLException e) {
            hostName = null;
        }
        if (StringUtils.isBlank(hostName)) {
            return null;
        }
        if ((hostName = SCMName.resolveInternetDomainName(hostName)) == null) {
            return null;
        }
        if (ignoredPrefixes != null) {
            for (String prefix : ignoredPrefixes) {
                if (prefix.endsWith(".")) {
                    if (!hostName.startsWith(prefix)) continue;
                    hostName = hostName.substring(prefix.length());
                    break;
                }
                if (!hostName.startsWith(prefix + ".")) continue;
                hostName = hostName.substring(prefix.length() + 1);
                break;
            }
        }
        if (StringUtils.isNotBlank((String)hostName)) {
            hostName = IDN.toUnicode(hostName).replace('.', ' ').replace('-', ' ');
        }
        return hostName;
    }

    private static String resolveInternetDomainName(String hostName) {
        InternetDomainName host;
        try {
            host = InternetDomainName.from((String)IDN.toASCII(hostName));
        }
        catch (IllegalArgumentException notADomainName) {
            return null;
        }
        if (host.hasPublicSuffix()) {
            String publicName = SCMName.name(host.publicSuffix());
            return StringUtils.removeEnd((String)StringUtils.removeEnd((String)SCMName.name(host), (String)publicName), (String)".").toLowerCase(Locale.ENGLISH);
        }
        return StringUtils.removeEnd((String)SCMName.name(host), (String)".").toLowerCase(Locale.ENGLISH);
    }

    private static String name(InternetDomainName host) {
        try {
            try {
                Method method = InternetDomainName.class.getMethod("name", new Class[0]);
                return (String)method.invoke((Object)host, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                return host.toString();
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

