/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.impl.trait;

import java.util.Map;
import java.util.TreeSet;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.impl.mock.MockRepositoryFlags;
import jenkins.scm.impl.mock.MockSCMController;
import jenkins.scm.impl.mock.MockSCMDiscoverBranches;
import jenkins.scm.impl.mock.MockSCMSource;
import jenkins.scm.impl.trait.RegexSCMHeadFilterTrait;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;

public class RegexSCMHeadFilterTraitTest {
    @ClassRule
    public static JenkinsRule r = new JenkinsRule();

    @Test
    public void given_sourceWithRegexRule_when_scanning_then_ruleApplied() throws Exception {
        try (MockSCMController c = MockSCMController.create();){
            c.createRepository("foo", new MockRepositoryFlags[0]);
            c.createBranch("foo", "fork");
            c.createBranch("foo", "alt");
            MockSCMSource src = new MockSCMSource(c, "foo", new SCMSourceTrait[]{new MockSCMDiscoverBranches(), new RegexSCMHeadFilterTrait("[fm].*")});
            Map result = ((SCMHeadObserver.Collector)src.fetch(null, (SCMHeadObserver)SCMHeadObserver.collect(), null, null)).result();
            TreeSet<String> names = new TreeSet<String>();
            for (SCMHead h : result.keySet()) {
                names.add(h.getName());
            }
            Assert.assertThat(names, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"master", "fork"}));
        }
    }
}

