/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api;

import jenkins.scm.api.SCMName;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class SCMNameTest {
    @Test
    public void given__url_without_hostname__when__naming__then__no_name_inferred() throws Exception {
        Assert.assertThat((Object)SCMName.fromUrl((String)"file:///some/random/file", (String[])new String[0]), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void given__url_with_hostname__when__naming__then__public_tld_removed() throws Exception {
        Assert.assertThat((Object)SCMName.fromUrl((String)"http://scm.example.com", (String[])new String[0]), (Matcher)Matchers.is((Object)"scm example"));
    }

    @Test
    public void given__url_with_hostname__when__naming__then__public_sld_removed() throws Exception {
        Assert.assertThat((Object)SCMName.fromUrl((String)"http://scm.example.co.uk", (String[])new String[0]), (Matcher)Matchers.is((Object)"scm example"));
    }

    @Test
    public void given__url_with_hostname__when__naming__then__prefix_is_removed() throws Exception {
        Assert.assertThat((Object)SCMName.fromUrl((String)"http://scm.example.ie", (String[])new String[]{"scm"}), (Matcher)Matchers.is((Object)"example"));
    }

    @Test
    public void given__url_with_punycode__when__naming__then__hostname_is_decoded() throws Exception {
        Assert.assertThat((Object)SCMName.fromUrl((String)"http://xn--e1afmkfd.xn--p1ai/", (String[])new String[0]), (Matcher)Matchers.is((Object)"\u043f\u0440\u0438\u043c\u0435\u0440"));
    }

    @Test
    public void given__url_with_idn__when__naming__then__punycode_is_roundtripped() throws Exception {
        Assert.assertThat((Object)SCMName.fromUrl((String)"http://\u043f\u0440\u0438\u043c\u0435\u0440.\u0440\u0444", (String[])new String[0]), (Matcher)Matchers.is((Object)"\u043f\u0440\u0438\u043c\u0435\u0440"));
    }

    @Test
    public void given__url_with_idn__when__naming__then__punycode_is_roundtripped2() throws Exception {
        Assert.assertThat((Object)SCMName.fromUrl((String)"http://\u4f8b\u5b50.\u4e2d\u56fd/", (String[])new String[0]), (Matcher)Matchers.is((Object)"\u4f8b\u5b50"));
    }

    @Test
    public void given__url_with_ipv4address__when__naming__then__no_name_inferred() throws Exception {
        Assert.assertThat((Object)SCMName.fromUrl((String)"http://127.0.0.1/scm", (String[])new String[0]), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }
}

