/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api.trait;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.DescriptorExtensionList;
import hudson.model.AbstractDescribableImpl;
import java.util.ArrayList;
import java.util.HashSet;
import jenkins.model.Jenkins;
import jenkins.scm.api.trait.SCMTraitDescriptor;

public abstract class SCMTrait<T extends SCMTrait<T>>
extends AbstractDescribableImpl<T> {
    public SCMTraitDescriptor<T> getDescriptor() {
        return (SCMTraitDescriptor)super.getDescriptor();
    }

    static <T extends SCMTrait<T>, D extends SCMTraitDescriptor<T>> DescriptorExtensionList<T, D> all(Class<T> specialization) {
        return Jenkins.getActiveInstance().getDescriptorList(specialization);
    }

    @NonNull
    public static <T extends SCMTrait<?>> ArrayList<T> asSetList(@CheckForNull Iterable<? extends T> list) {
        ArrayList<SCMTrait> result = new ArrayList<SCMTrait>();
        if (list != null) {
            HashSet seen = new HashSet();
            for (SCMTrait trait : list) {
                if (trait == null || seen.contains(((Object)((Object)trait)).getClass())) continue;
                seen.add(((Object)((Object)trait)).getClass());
                result.add(trait);
            }
        }
        return result;
    }

    public static <T extends SCMTrait<?>> ArrayList<T> asSetList(@NonNull T first, @CheckForNull Iterable<? extends T> list) {
        ArrayList<SCMTrait> result = new ArrayList<SCMTrait>();
        result.add(first);
        if (list != null) {
            HashSet seen = new HashSet();
            seen.add(((Object)first).getClass());
            for (SCMTrait trait : list) {
                if (trait == null || seen.contains(((Object)((Object)trait)).getClass())) continue;
                seen.add(((Object)((Object)trait)).getClass());
                result.add(trait);
            }
        }
        return result;
    }

    @CheckForNull
    public static <T extends SCMTrait<?>> T find(@NonNull Iterable<?> traits, @NonNull Class<T> clazz) {
        for (Object trait : traits) {
            if (!clazz.isInstance(trait)) continue;
            return (T)((Object)((SCMTrait)((Object)clazz.cast(trait))));
        }
        return null;
    }
}

