/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import jenkins.scm.api.SCMFile;

public class SCMProbeStat {
    @CheckForNull
    private String alternativePath;
    @NonNull
    private SCMFile.Type type;

    private SCMProbeStat(@NonNull SCMFile.Type type, @CheckForNull String alternativePath) {
        this.type = type;
        this.alternativePath = type != SCMFile.Type.NONEXISTENT ? null : alternativePath;
    }

    public static SCMProbeStat fromType(@NonNull SCMFile.Type type) {
        return new SCMProbeStat(type, null);
    }

    public static SCMProbeStat fromAlternativePath(@NonNull String alternativePath) {
        return new SCMProbeStat(SCMFile.Type.NONEXISTENT, alternativePath);
    }

    public boolean exists() {
        return this.type != SCMFile.Type.NONEXISTENT;
    }

    @CheckForNull
    public String getAlternativePath() {
        return this.alternativePath;
    }

    @NonNull
    public SCMFile.Type getType() {
        return this.type;
    }
}

