/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.net.IDN;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class SCMUri {
    private static final Map<String, Integer> commonDefaultPorts;

    private SCMUri() {
        throw new IllegalAccessError("Utility class");
    }

    public static Map<String, Integer> commonDefaultPorts() {
        return commonDefaultPorts;
    }

    @CheckForNull
    public static String normalize(@CheckForNull String uri) {
        return SCMUri.normalize(uri, commonDefaultPorts);
    }

    @CheckForNull
    public static String normalize(@CheckForNull String uri, Map<String, Integer> ... defaultPorts) {
        if (uri == null) {
            return null;
        }
        try {
            String host;
            Map<String, Integer> ports;
            URI u = new URI(uri).normalize();
            String scheme = u.getScheme().toLowerCase(Locale.ENGLISH);
            Integer defaultPort = null;
            Map<String, Integer>[] mapArray = defaultPorts;
            int n = mapArray.length;
            for (int i = 0; i < n && (defaultPort = (ports = mapArray[i]).get(scheme)) == null; ++i) {
            }
            if (defaultPort != null) {
                host = u.getHost();
                if (host != null) {
                    host = host.toLowerCase(Locale.ENGLISH);
                    int port = u.getPort();
                    uri = new URI(scheme, u.getUserInfo(), host, port == defaultPort ? -1 : port, u.getPath(), u.getQuery(), u.getFragment()).toASCIIString();
                } else {
                    String authority = u.getAuthority();
                    if (authority != null) {
                        String portPart;
                        String portSep;
                        String userSep;
                        String userPart;
                        int at = authority.indexOf(64);
                        int colon = authority.lastIndexOf(58);
                        if (colon != -1 && at > colon) {
                            colon = -1;
                        }
                        if (colon != -1) {
                            for (int i = colon + 1; i < authority.length(); ++i) {
                                if (Character.isDigit(authority.codePointAt(i))) continue;
                                colon = -1;
                                break;
                            }
                        }
                        if (at == -1) {
                            userPart = "";
                            userSep = "";
                        } else {
                            userPart = authority.substring(0, at);
                            userSep = "@";
                        }
                        if (colon == -1) {
                            portSep = "";
                            portPart = "";
                        } else {
                            int port = Integer.parseInt(authority.substring(colon + 1));
                            if (port != defaultPort) {
                                portSep = ":";
                                portPart = Integer.toString(port);
                            } else {
                                portSep = "";
                                portPart = "";
                            }
                        }
                        String hostPart = IDN.toASCII(authority.substring(at + 1, colon == -1 ? authority.length() : colon)).toLowerCase(Locale.ENGLISH);
                        authority = userPart + userSep + hostPart + portSep + portPart;
                    }
                    uri = new URI(scheme, authority, u.getPath(), u.getQuery(), u.getFragment()).toASCIIString();
                }
            } else {
                host = u.getHost();
                if (u.getHost() != null) {
                    host = host.toLowerCase(Locale.ENGLISH);
                    uri = new URI(scheme, u.getUserInfo(), host, u.getPort(), u.getPath(), u.getQuery(), u.getFragment()).toASCIIString();
                } else {
                    uri = new URI(scheme, u.getSchemeSpecificPart(), u.getFragment()).toASCIIString();
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return uri.replaceAll("/$", "");
    }

    static {
        HashMap<String, Integer> ports = new HashMap<String, Integer>();
        ports.put("ftp", 21);
        ports.put("ssh", 22);
        ports.put("telnet", 22);
        ports.put("http", 80);
        ports.put("https", 443);
        commonDefaultPorts = Collections.unmodifiableMap(ports);
    }
}

