/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.scm.SCM;
import hudson.util.AlternativeUiTextProvider;
import hudson.util.LogTaskListener;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.scm.api.MethodUtils;
import jenkins.scm.api.SCMFile;
import jenkins.scm.api.SCMFileSystem;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadCategory;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMProbe;
import jenkins.scm.api.SCMProbeStat;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.api.SCMSourceEvent;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.trait.SCMSourceTrait;
import net.jcip.annotations.GuardedBy;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public abstract class SCMSource
extends AbstractDescribableImpl<SCMSource>
implements ExtensionPoint {
    public static final AlternativeUiTextProvider.Message<SCMSource> PRONOUN = new AlternativeUiTextProvider.Message();
    private static final ThreadLocal<SCMSourceCriteria> compatibilityHack = new ThreadLocal();
    private static final SCMSourceCriteria nullSCMSourceCriteria = new SCMSourceCriteria(){

        @Override
        public boolean isHead(@NonNull SCMSourceCriteria.Probe probe, @NonNull TaskListener listener) throws IOException {
            return true;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }
    };
    @GuardedBy(value="this")
    @CheckForNull
    private String id;
    @GuardedBy(value="this")
    @CheckForNull
    private transient SCMSourceOwner owner;

    @Deprecated
    protected SCMSource(@CheckForNull String id) {
        this.id = id == null ? UUID.randomUUID().toString() : id;
    }

    protected SCMSource() {
    }

    @DataBoundSetter
    public final synchronized void setId(@CheckForNull String id) {
        if (this.id == null) {
            this.id = id;
        } else if (!this.id.equals(id)) {
            throw new IllegalStateException("The ID cannot be changed after it has been set.");
        }
    }

    public final SCMSource withId(@CheckForNull String id) {
        this.setId(id);
        return this;
    }

    public final synchronized boolean hasId() {
        return this.id != null;
    }

    @NonNull
    public final synchronized String getId() {
        if (this.id == null) {
            this.id = UUID.randomUUID().toString();
        }
        return this.id;
    }

    public void setTraits(@CheckForNull List<SCMSourceTrait> traits) {
    }

    @CheckForNull
    public List<SCMSourceTrait> getTraits() {
        return Collections.emptyList();
    }

    public final synchronized void setOwner(@CheckForNull SCMSourceOwner owner) {
        this.owner = owner;
    }

    @CheckForNull
    public final synchronized SCMSourceOwner getOwner() {
        return this.owner;
    }

    @CheckForNull
    protected final SCMSourceCriteria getCriteria() {
        SCMSourceCriteria hack = compatibilityHack.get();
        if (hack != null) {
            return hack == nullSCMSourceCriteria ? null : hack;
        }
        SCMSourceOwner owner = this.getOwner();
        if (owner == null) {
            return null;
        }
        return owner.getSCMSourceCriteria(this);
    }

    @NonNull
    public final <O extends SCMHeadObserver> O fetch(@NonNull O observer, @CheckForNull TaskListener listener) throws IOException, InterruptedException {
        this._retrieve(this.getCriteria(), observer, null, this.defaultListener(listener));
        return observer;
    }

    @NonNull
    public final <O extends SCMHeadObserver> O fetch(@CheckForNull SCMSourceCriteria criteria, @NonNull O observer, @CheckForNull TaskListener listener) throws IOException, InterruptedException {
        this._retrieve(criteria, observer, null, this.defaultListener(listener));
        return observer;
    }

    @NonNull
    public final <O extends SCMHeadObserver> O fetch(@CheckForNull SCMSourceCriteria criteria, @NonNull O observer, @CheckForNull SCMHeadEvent<?> event, @CheckForNull TaskListener listener) throws IOException, InterruptedException {
        this._retrieve(criteria, (SCMHeadObserver)(event == null ? observer : event.filter(this, observer)), event, this.defaultListener(listener));
        return observer;
    }

    @NonNull
    public final <O extends SCMHeadObserver> O fetch(@NonNull O observer, @CheckForNull SCMHeadEvent<?> event, @CheckForNull TaskListener listener) throws IOException, InterruptedException {
        this._retrieve(this.getCriteria(), (SCMHeadObserver)(event == null ? observer : event.filter(this, observer)), event, this.defaultListener(listener));
        return observer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _retrieve(@CheckForNull SCMSourceCriteria criteria, @NonNull SCMHeadObserver observer, @CheckForNull SCMHeadEvent<?> event, @CheckForNull TaskListener listener) throws IOException, InterruptedException {
        if (MethodUtils.isOverridden(SCMSource.class, ((Object)((Object)this)).getClass(), "retrieve", SCMSourceCriteria.class, SCMHeadObserver.class, SCMHeadEvent.class, TaskListener.class)) {
            this.retrieve(criteria, observer, event, this.defaultListener(listener));
            return;
        }
        if (MethodUtils.isOverridden(SCMSource.class, ((Object)((Object)this)).getClass(), "retrieve", SCMSourceCriteria.class, SCMHeadObserver.class, TaskListener.class)) {
            if (event == null) {
                this.retrieve(criteria, observer, this.defaultListener(listener));
                return;
            } else {
                if (!event.isMatch(this)) return;
                this.retrieve(criteria, event.filter(this, observer), this.defaultListener(listener));
            }
            return;
        }
        if (!MethodUtils.isOverridden(SCMSource.class, ((Object)((Object)this)).getClass(), "retrieve", SCMHeadObserver.class, TaskListener.class)) throw new AbstractMethodError("Implement retrieve(SCMSourceCriteria,SCMHeadObserver,TaskListener)");
        SCMSourceCriteria hopefullyNull = compatibilityHack.get();
        compatibilityHack.set(criteria == null ? nullSCMSourceCriteria : criteria);
        try {
            if (event == null) {
                this.retrieve(observer, this.defaultListener(listener));
                return;
            } else {
                if (!event.isMatch(this)) return;
                this.retrieve(event.filter(this, observer), this.defaultListener(listener));
            }
            return;
        }
        finally {
            if (hopefullyNull != null) {
                compatibilityHack.set(hopefullyNull);
            } else {
                compatibilityHack.remove();
            }
        }
    }

    @Deprecated
    protected void retrieve(@NonNull SCMHeadObserver observer, @NonNull TaskListener listener) throws IOException, InterruptedException {
        if (!MethodUtils.isOverridden(SCMSource.class, ((Object)((Object)this)).getClass(), "retrieve", SCMSourceCriteria.class, SCMHeadObserver.class, TaskListener.class)) {
            throw new AbstractMethodError("Implement retrieve(SCMSourceCriteria,SCMHeadObserver,TaskListener)");
        }
        this.retrieve(this.getCriteria(), observer, listener);
    }

    @Deprecated
    protected void retrieve(@CheckForNull SCMSourceCriteria criteria, @NonNull SCMHeadObserver observer, @NonNull TaskListener listener) throws IOException, InterruptedException {
        this._retrieve(criteria, observer, null, listener);
    }

    protected abstract void retrieve(@CheckForNull SCMSourceCriteria var1, @NonNull SCMHeadObserver var2, @CheckForNull SCMHeadEvent<?> var3, @NonNull TaskListener var4) throws IOException, InterruptedException;

    @NonNull
    public final Set<SCMHead> fetch(@CheckForNull TaskListener listener) throws IOException, InterruptedException {
        return this.retrieve(this.defaultListener(listener));
    }

    @NonNull
    public Set<SCMRevision> parentRevisions(@NonNull SCMHead head, @NonNull SCMRevision revision, @CheckForNull TaskListener listener) throws IOException, InterruptedException {
        return Collections.emptySet();
    }

    @NonNull
    public Map<SCMHead, SCMRevision> parentHeads(@NonNull SCMHead head, @CheckForNull TaskListener listener) throws IOException, InterruptedException {
        return Collections.emptyMap();
    }

    @NonNull
    protected Set<SCMHead> retrieve(@NonNull TaskListener listener) throws IOException, InterruptedException {
        return this.retrieve(this.getCriteria(), listener);
    }

    @NonNull
    protected Set<SCMHead> retrieve(@CheckForNull SCMSourceCriteria criteria, @NonNull TaskListener listener) throws IOException, InterruptedException {
        SCMHeadObserver.Collector collector = SCMHeadObserver.collect();
        this._retrieve(criteria, collector, null, listener);
        return collector.result().keySet();
    }

    @CheckForNull
    public final SCMRevision fetch(@NonNull SCMHead head, @CheckForNull TaskListener listener) throws IOException, InterruptedException {
        return this.retrieve(head, this.defaultListener(listener));
    }

    @CheckForNull
    protected SCMRevision retrieve(@NonNull SCMHead head, @NonNull TaskListener listener) throws IOException, InterruptedException {
        SCMHeadObserver.Selector selector = SCMHeadObserver.select(head);
        this._retrieve(null, selector, null, listener);
        return selector.result();
    }

    @CheckForNull
    public final SCMRevision fetch(@NonNull String thingName, @CheckForNull TaskListener listener) throws IOException, InterruptedException {
        return this.retrieve(thingName, this.defaultListener(listener));
    }

    @CheckForNull
    protected SCMRevision retrieve(@NonNull String thingName, @NonNull TaskListener listener) throws IOException, InterruptedException {
        SCMHeadObserver.Named baptist = SCMHeadObserver.named(thingName);
        this._retrieve(null, baptist, null, listener);
        return baptist.result();
    }

    @NonNull
    public final Set<String> fetchRevisions(@CheckForNull TaskListener listener) throws IOException, InterruptedException {
        return this.retrieveRevisions(this.defaultListener(listener));
    }

    @NonNull
    protected Set<String> retrieveRevisions(@NonNull TaskListener listener) throws IOException, InterruptedException {
        HashSet<String> revisions = new HashSet<String>();
        for (SCMHead head : this.retrieve(listener)) {
            revisions.add(head.getName());
        }
        return revisions;
    }

    @NonNull
    public final List<Action> fetchActions(@NonNull SCMRevision revision, @CheckForNull SCMHeadEvent event, @CheckForNull TaskListener listener) throws IOException, InterruptedException {
        return Util.fixNull(this.retrieveActions(revision, event, this.defaultListener(listener)));
    }

    @NonNull
    public final List<Action> fetchActions(@NonNull SCMHead head, @CheckForNull SCMHeadEvent event, @CheckForNull TaskListener listener) throws IOException, InterruptedException {
        return Util.fixNull(this.retrieveActions(head, event, this.defaultListener(listener)));
    }

    @NonNull
    public final List<Action> fetchActions(@CheckForNull SCMSourceEvent event, @CheckForNull TaskListener listener) throws IOException, InterruptedException {
        return Util.fixNull(this.retrieveActions(event, this.defaultListener(listener)));
    }

    @NonNull
    protected List<Action> retrieveActions(@NonNull SCMRevision revision, @CheckForNull SCMHeadEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        return Collections.emptyList();
    }

    @NonNull
    protected List<Action> retrieveActions(@NonNull SCMHead head, @CheckForNull SCMHeadEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        return Collections.emptyList();
    }

    @NonNull
    protected List<Action> retrieveActions(@CheckForNull SCMSourceEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        return Collections.emptyList();
    }

    @NonNull
    public abstract SCM build(@NonNull SCMHead var1, @CheckForNull SCMRevision var2);

    @NonNull
    public final SCM build(@NonNull SCMHead head) {
        return this.build(head, null);
    }

    @NonNull
    public SCMRevision getTrustedRevision(@NonNull SCMRevision revision, @NonNull TaskListener listener) throws IOException, InterruptedException {
        return revision;
    }

    @NonNull
    protected final TaskListener defaultListener(@CheckForNull TaskListener listener) {
        if (listener == null) {
            Level level;
            try {
                level = Level.parse(System.getProperty(((Object)((Object)this)).getClass().getName() + ".defaultListenerLevel", "FINE"));
            }
            catch (IllegalArgumentException e) {
                level = Level.FINE;
            }
            return new LogTaskListener(Logger.getLogger(((Object)((Object)this)).getClass().getName()), level);
        }
        return listener;
    }

    public boolean canProbe() {
        return MethodUtils.isOverridden(SCMSource.class, ((Object)((Object)this)).getClass(), "createProbe", SCMHead.class, SCMRevision.class);
    }

    @NonNull
    public final SCMProbe newProbe(@NonNull SCMHead head, @CheckForNull SCMRevision revision) throws IOException {
        if (revision != null && !revision.getHead().equals(head)) {
            throw new IllegalArgumentException("Mismatched head and revision");
        }
        try {
            return this.createProbe(head, revision);
        }
        catch (AbstractMethodError e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @NonNull
    protected SCMProbe createProbe(@NonNull SCMHead head, @CheckForNull SCMRevision revision) throws IOException {
        throw new AbstractMethodError();
    }

    @CheckForNull
    protected final SCMProbe fromSCMFileSystem(final @NonNull SCMHead head, @CheckForNull SCMRevision revision) throws IOException, InterruptedException {
        final SCMFileSystem fileSystem = SCMFileSystem.of(this, head, revision);
        if (fileSystem != null) {
            return new SCMProbe(){

                @Override
                @NonNull
                public SCMProbeStat stat(@NonNull String path) throws IOException {
                    try {
                        return SCMProbeStat.fromType(fileSystem.child(path).getType());
                    }
                    catch (InterruptedException e) {
                        throw new IOException("Interrupted", e);
                    }
                }

                @Override
                public void close() throws IOException {
                    fileSystem.close();
                }

                @Override
                public String name() {
                    return head.getName();
                }

                @Override
                public long lastModified() {
                    try {
                        return fileSystem.lastModified();
                    }
                    catch (IOException e) {
                        return 0L;
                    }
                    catch (InterruptedException e) {
                        return 0L;
                    }
                }

                @Override
                public SCMFile getRoot() {
                    return fileSystem.getRoot();
                }
            };
        }
        return null;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SCMSource)) {
            return false;
        }
        SCMSource that = (SCMSource)((Object)o);
        return this.getId().equals(that.getId());
    }

    public final int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(((Object)((Object)this)).getClass().getName());
        sb.append("{id='").append(this.id).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public SCMSourceDescriptor getDescriptor() {
        return (SCMSourceDescriptor)super.getDescriptor();
    }

    @CheckForNull
    public String getPronoun() {
        return AlternativeUiTextProvider.get(PRONOUN, (Object)((Object)this), (String)this.getDescriptor().getPronoun());
    }

    @NonNull
    public final Set<? extends SCMHeadCategory> getCategories() {
        Set<SCMHeadCategory> result = this.getDescriptor().getCategories();
        if (result.size() > 1 && MethodUtils.isOverridden(SCMSource.class, ((Object)((Object)this)).getClass(), "isCategoryEnabled", SCMHeadCategory.class)) {
            result = new LinkedHashSet<SCMHeadCategory>(result);
            Iterator<SCMHeadCategory> iterator = result.iterator();
            while (iterator.hasNext()) {
                SCMHeadCategory category = iterator.next();
                if (category.isUncategorized() || this.isCategoryEnabled(category)) continue;
                iterator.remove();
            }
        }
        return result;
    }

    protected boolean isCategoryEnabled(@NonNull SCMHeadCategory category) {
        return true;
    }

    protected final void checkInterrupt() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    public void afterSave() {
    }

    public static abstract class SourceByItem
    implements ExtensionPoint {
        @CheckForNull
        public abstract SCMSource getSource(Item var1);

        @CheckForNull
        public static SCMSource findSource(Item item) {
            for (SourceByItem ext : ExtensionList.lookup(SourceByItem.class)) {
                SCMSource source = ext.getSource(item);
                if (source == null) continue;
                return source;
            }
            return null;
        }
    }
}

