/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api.trait;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.trait.SCMNavigatorRequest;
import jenkins.scm.api.trait.SCMNavigatorTrait;
import jenkins.scm.api.trait.SCMSourceDecorator;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMTrait;

public abstract class SCMSourceBuilder<B extends SCMSourceBuilder<B, S>, S extends SCMSource> {
    @NonNull
    private final Class<S> clazz;
    @NonNull
    private final String projectName;
    @NonNull
    private final List<SCMSourceTrait> traits = new ArrayList<SCMSourceTrait>();

    public SCMSourceBuilder(@NonNull Class<S> clazz, @NonNull String projectName) {
        this.clazz = clazz;
        this.projectName = projectName;
    }

    @NonNull
    public final Class<S> sourceClass() {
        return this.clazz;
    }

    @NonNull
    public final String projectName() {
        return this.projectName;
    }

    @NonNull
    public final List<SCMSourceTrait> traits() {
        return Collections.unmodifiableList(this.traits);
    }

    @NonNull
    public final B withTrait(@NonNull SCMNavigatorTrait trait) {
        trait.applyToBuilder(this);
        return (B)this;
    }

    @NonNull
    public final B withTrait(@NonNull SCMSourceTrait trait) {
        this.traits.add(trait);
        return (B)this;
    }

    @NonNull
    public final B withTraits(SCMTrait<? extends SCMTrait<?>> ... traits) {
        return this.withTraits(Arrays.asList(traits));
    }

    @NonNull
    public B withTraits(@NonNull Collection<? extends SCMTrait<?>> traits) {
        for (SCMTrait<?> trait : traits) {
            if (trait instanceof SCMNavigatorTrait) {
                this.withTrait((SCMNavigatorTrait)trait);
                continue;
            }
            if (trait instanceof SCMSourceTrait) {
                this.withTrait((SCMSourceTrait)trait);
                continue;
            }
            throw new IllegalArgumentException("Unsupported trait: " + ((Object)trait).getClass().getName());
        }
        return (B)this;
    }

    public B withRequest(@NonNull SCMNavigatorRequest request) {
        this.withTraits(request.traits());
        for (SCMSourceDecorator<?, ?> decorator : request.decorators()) {
            decorator.applyTo(this, this.projectName());
        }
        return (B)this;
    }

    @NonNull
    public abstract S build();
}

