/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.impl.avatars;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.Util;
import hudson.model.RootAction;
import hudson.model.UnprotectedRootAction;
import hudson.util.DaemonThreadFactory;
import hudson.util.HttpResponses;
import hudson.util.NamingThreadFactory;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension
public class AvatarCache
implements UnprotectedRootAction {
    private static final Logger LOGGER = Logger.getLogger(AvatarCache.class.getName());
    private static final String UTF_8 = "UTF-8";
    static final int CONCURRENT_REQUEST_LIMIT = 4;
    private final ConcurrentMap<String, CacheEntry> cache = new ConcurrentHashMap<String, CacheEntry>();
    final ThreadPoolExecutor service = new ThreadPoolExecutor(4, 4, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamingThreadFactory((ThreadFactory)new DaemonThreadFactory(), this.getClass().getName()));
    private final Object serviceLock = new Object();
    private Iterator<Map.Entry<String, CacheEntry>> iterator = null;
    private final long startedTime;

    public AvatarCache() {
        this.service.allowCoreThreadTimeOut(true);
        this.startedTime = System.currentTimeMillis() / 1000L * 1000L;
    }

    public static String buildUrl(@NonNull String url, @NonNull String size) {
        Jenkins j = Jenkins.getActiveInstance();
        AvatarCache instance = (AvatarCache)j.getExtensionList(RootAction.class).get(AvatarCache.class);
        if (instance == null) {
            throw new AssertionError();
        }
        String key = Util.getDigestOf((String)(AvatarCache.class.getName() + url));
        instance.getCacheEntry(key, url);
        try {
            return j.getRootUrlFromRequest() + instance.getUrlName() + "/" + Util.rawEncode((String)key) + ".png?size=" + URLEncoder.encode(size, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            AssertionError error = new AssertionError((Object)"JLS specification mandates support for UTF-8 encoding");
            ((Throwable)((Object)error)).initCause(e);
            throw error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static BufferedImage scaleImage(@NonNull BufferedImage src, int size) {
        int newHeight;
        int newWidth;
        if (src.getWidth() > src.getHeight()) {
            newWidth = size;
            newHeight = size * src.getHeight() / src.getWidth();
        } else if (src.getHeight() > src.getWidth()) {
            newWidth = size * src.getWidth() / src.getHeight();
            newHeight = size;
        } else {
            newWidth = newHeight = size;
        }
        boolean flushSrc = false;
        if (newWidth <= src.getWidth() * 6 / 7 && newHeight <= src.getWidth() * 6 / 7) {
            int curWidth = src.getWidth();
            int curHeight = src.getHeight();
            int penultimateSize = size * 7 / 6;
            while (true) {
                curWidth -= curWidth / 7;
                curHeight -= curHeight / 7;
                if (curWidth <= penultimateSize && curHeight <= penultimateSize) break;
                BufferedImage tmp = new BufferedImage(curWidth, curHeight, 2);
                Graphics2D g = tmp.createGraphics();
                try {
                    g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                    g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                    g.scale((double)curWidth / (double)src.getWidth(), (double)curHeight / (double)src.getHeight());
                    g.drawImage((Image)src, 0, 0, null);
                }
                finally {
                    g.dispose();
                }
                if (flushSrc) {
                    src.flush();
                }
                src = tmp;
                flushSrc = true;
            }
        }
        BufferedImage tmp = new BufferedImage(size, size, 2);
        Graphics2D g = tmp.createGraphics();
        try {
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            g.scale((double)newWidth / (double)src.getWidth(), (double)newHeight / (double)src.getHeight());
            g.drawImage((Image)src, (size - newWidth) / 2, (size - newHeight) / 2, null);
        }
        finally {
            g.dispose();
        }
        if (flushSrc) {
            src.flush();
        }
        src = tmp;
        return src;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage generateAvatar(@NonNull String seed, int size) {
        byte[] bytes;
        try {
            MessageDigest d = MessageDigest.getInstance("MD5");
            bytes = d.digest(seed.getBytes(UTF_8));
        }
        catch (NoSuchAlgorithmException e) {
            AssertionError error = new AssertionError((Object)"JLS specification mandates support for MD5 message digest");
            ((Throwable)((Object)error)).initCause(e);
            throw error;
        }
        catch (UnsupportedEncodingException e) {
            AssertionError error = new AssertionError((Object)"JLS specification mandates support for UTF-8 encoding");
            ((Throwable)((Object)error)).initCause(e);
            throw error;
        }
        BufferedImage canvas = new BufferedImage(size, size, 2);
        Graphics2D g = canvas.createGraphics();
        try {
            g.setColor(new Color(bytes[0] & 0xEF, bytes[1] & 0xEF, bytes[2] & 0xEF));
            int pSize = size / 5;
            int pOffset = (size - pSize * 5) / 2;
            for (int y = 0; y < 5; ++y) {
                for (int x = 0; x < 5; ++x) {
                    byte bit = (byte)(1 << Math.min(x, 4 - x));
                    if ((bytes[3 + y] & bit) == 0) continue;
                    g.fillRect(pOffset + x * pSize, pOffset + y * pSize, pSize, pSize);
                }
            }
        }
        finally {
            g.dispose();
        }
        return canvas;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "avatar-cache";
    }

    public HttpResponse doDynamic(StaplerRequest req, @QueryParameter String size) {
        if (StringUtils.isBlank((String)req.getRestOfPath())) {
            return HttpResponses.notFound();
        }
        String key = req.getRestOfPath().substring(1);
        if (!key.endsWith(".png")) {
            return HttpResponses.notFound();
        }
        key = StringUtils.removeEnd((String)key, (String)".png");
        size = StringUtils.defaultIfBlank((String)size, (String)"48x48");
        int targetSize = 48;
        int index = size.toLowerCase(Locale.ENGLISH).indexOf(120);
        if (index < 2) {
            try {
                targetSize = Math.min(128, Math.max(16, Integer.parseInt(StringUtils.trim((String)size))));
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            try {
                targetSize = Math.min(128, Math.max(16, Integer.parseInt(StringUtils.trim((String)size.substring(0, index)))));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        final CacheEntry avatar = this.getCacheEntry(key, null);
        long since = req.getDateHeader("If-Modified-Since");
        if (avatar == null || !avatar.url.startsWith("http://") && !avatar.url.startsWith("https://")) {
            if (this.startedTime <= since) {
                return new HttpResponse(){

                    public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
                        rsp.addDateHeader("Last-Modified", AvatarCache.this.startedTime);
                        rsp.addHeader("Cache-control", "max-age=365000000, immutable, public");
                        rsp.setStatus(304);
                    }
                };
            }
            return new ImageResponse(AvatarCache.generateAvatar(avatar == null ? "" : avatar.url, targetSize), true, this.startedTime, "max-age=365000000, immutable, public");
        }
        if (avatar.pending() && avatar.image == null) {
            return new ImageResponse(AvatarCache.generateAvatar(avatar.url, targetSize), true, -1L, "no-cache, public");
        }
        if (avatar.lastModified <= since) {
            return new HttpResponse(){

                public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
                    rsp.addDateHeader("Last-Modified", avatar.lastModified);
                    rsp.addHeader("Cache-control", "max-age=3600, public");
                    rsp.setStatus(304);
                }
            };
        }
        if (avatar.image == null) {
            return new ImageResponse(AvatarCache.generateAvatar(avatar.url, targetSize), true, -1L, "max-age=3600, public");
        }
        BufferedImage image = avatar.image;
        boolean flushImage = false;
        if (image.getWidth() != targetSize || image.getHeight() != targetSize) {
            image = AvatarCache.scaleImage(image, targetSize);
            flushImage = true;
        }
        return new ImageResponse(image, flushImage, avatar.lastModified, "max-age=3600, public");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private CacheEntry getCacheEntry(@NonNull String key, @Nullable String url) {
        Iterator<Map.Entry<String, CacheEntry>> iterator;
        CacheEntry entry = (CacheEntry)this.cache.get(key);
        if (entry == null) {
            iterator = this.serviceLock;
            synchronized (iterator) {
                entry = (CacheEntry)this.cache.get(key);
                if (entry == null) {
                    if (url == null) {
                        return null;
                    }
                    entry = new CacheEntry(url, this.service.submit(new FetchImage(url)));
                    this.cache.put(key, entry);
                }
            }
        }
        if (entry.isStale()) {
            iterator = this.serviceLock;
            synchronized (iterator) {
                if (!entry.pending()) {
                    entry.setFuture(this.service.submit(new FetchImage(entry.url)));
                }
            }
        }
        entry.touch();
        if (this.iterator == null || !this.iterator.hasNext()) {
            iterator = this.serviceLock;
            synchronized (iterator) {
                if (this.iterator == null || !this.iterator.hasNext()) {
                    this.iterator = this.cache.entrySet().iterator();
                }
            }
        }
        iterator = this.iterator;
        synchronized (iterator) {
            if (this.iterator.hasNext()) {
                Map.Entry<String, CacheEntry> next = this.iterator.next();
                if (next.getValue().isUnused()) {
                    this.iterator.remove();
                }
            } else {
                this.iterator = null;
            }
        }
        return entry;
    }

    static /* synthetic */ Logger access$1300() {
        return LOGGER;
    }

    private static class FetchImage
    implements Callable<CacheEntry> {
        private final String url;

        private FetchImage(String url) {
            this.url = url;
        }

        /*
         * Exception decompiling
         */
        @Override
        public CacheEntry call() throws Exception {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private static class ImageResponse
    implements HttpResponse {
        private final BufferedImage image;
        private final boolean flushImage;
        private final String cacheControl;
        private final long lastModified;

        private ImageResponse(BufferedImage image, boolean flushImage, long lastModified, String cacheControl) {
            this.cacheControl = cacheControl;
            this.image = image;
            this.flushImage = flushImage;
            this.lastModified = lastModified;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)this.image, "png", bos);
            }
            finally {
                if (this.flushImage) {
                    this.image.flush();
                }
            }
            byte[] bytes = bos.toByteArray();
            if (this.lastModified > 0L) {
                rsp.addDateHeader("Last-Modified", this.lastModified);
            }
            rsp.addHeader("Cache-control", this.cacheControl);
            rsp.setContentType("image/png");
            rsp.setContentLength(bytes.length);
            rsp.getOutputStream().write(bytes);
        }
    }

    private static class CacheEntry {
        private final String url;
        @CheckForNull
        private BufferedImage image;
        private long lastModified;
        private long lastAccessed = -1L;
        private Future<CacheEntry> future;

        private CacheEntry(String url, BufferedImage image, long lastModified) {
            this.url = url;
            if (image.getHeight() > 128 || image.getWidth() > 128) {
                this.image = AvatarCache.scaleImage(image, 128);
                image.flush();
            } else {
                this.image = image;
            }
            this.lastModified = lastModified < 0L ? System.currentTimeMillis() : lastModified;
        }

        private CacheEntry(String url, Future<CacheEntry> future) {
            this.url = url;
            this.image = null;
            this.lastModified = System.currentTimeMillis();
            this.future = future;
        }

        private CacheEntry(String url) {
            this.url = url;
            this.lastModified = System.currentTimeMillis();
        }

        private synchronized boolean pending() {
            if (this.future == null) {
                return false;
            }
            if (this.future.isDone()) {
                try {
                    CacheEntry pending = this.future.get();
                    if (pending.image != null && this.image != null) {
                        this.image.flush();
                    }
                    if (pending.image != null) {
                        this.image = pending.image;
                    }
                    this.lastModified = pending.lastModified;
                    this.future = null;
                    return false;
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
            return true;
        }

        private synchronized void setFuture(Future<CacheEntry> future) {
            this.future = future;
        }

        private synchronized boolean isStale() {
            return System.currentTimeMillis() - this.lastModified > TimeUnit.HOURS.toMillis(1L);
        }

        private void touch() {
            this.lastAccessed = System.currentTimeMillis();
        }

        private boolean isUnused() {
            return this.lastAccessed > 0L && System.currentTimeMillis() - this.lastAccessed > TimeUnit.HOURS.toMillis(2L);
        }
    }
}

