/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jenkins.scm.api.Messages;
import jenkins.scm.api.SCMCategory;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMSource;
import jenkins.scm.impl.UncategorizedSCMSourceCategory;
import org.jvnet.localizer.Localizable;

public abstract class SCMSourceCategory
extends SCMCategory<SCMSource> {
    @NonNull
    public static List<SCMSourceCategory> collect(@NonNull Iterable<SCMNavigator> navigators) {
        ArrayList<SCMSourceCategory> result = new ArrayList<SCMSourceCategory>();
        for (SCMNavigator source : navigators) {
            block1: for (SCMSourceCategory sCMSourceCategory : source.getCategories()) {
                for (SCMSourceCategory added : result) {
                    if (sCMSourceCategory != added) continue;
                    continue block1;
                }
                result.add(sCMSourceCategory);
            }
        }
        return result;
    }

    public static List<SCMSourceCategory> addUncategorizedIfMissing(List<SCMSourceCategory> categories) {
        for (SCMSourceCategory category : categories) {
            if (!category.isUncategorized()) continue;
            return categories;
        }
        categories.add(UncategorizedSCMSourceCategory.DEFAULT);
        return categories;
    }

    public static SCMSourceCategory union(List<SCMSourceCategory> categories) {
        Localizable displayName;
        if (categories.size() == 1) {
            return categories.get(0);
        }
        boolean includesCatchAll = false;
        final ArrayList<SCMSourceCategory> _categories = new ArrayList<SCMSourceCategory>(categories);
        for (SCMSourceCategory c : _categories) {
            if (!c.isUncategorized()) continue;
            includesCatchAll = true;
            break;
        }
        if (includesCatchAll) {
            displayName = SCMSourceCategory.toDisplayName(_categories);
            return new SCMSourceCategory(displayName){

                @Override
                @NonNull
                protected Localizable defaultDisplayName() {
                    return displayName;
                }

                @Override
                public boolean isMatch(@NonNull SCMSource instance) {
                    return true;
                }
            };
        }
        displayName = SCMSourceCategory.toDisplayName(_categories);
        String name = SCMSourceCategory.toShortUrl(_categories);
        return new SCMSourceCategory(name, displayName){

            @Override
            @NonNull
            protected Localizable defaultDisplayName() {
                return displayName;
            }

            @Override
            public boolean isMatch(@NonNull SCMSource instance) {
                for (SCMSourceCategory c : _categories) {
                    if (!c.isMatch(instance)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Map<String, SCMSourceCategory> simplify(Iterable<SCMSourceCategory> categories) {
        TreeMap<String, SCMSourceCategory> result = new TreeMap<String, SCMSourceCategory>();
        for (Map.Entry<String, List<SCMSourceCategory>> entry : SCMSourceCategory.group(categories).entrySet()) {
            result.put(entry.getKey(), SCMSourceCategory.union(entry.getValue()));
        }
        return result;
    }

    public static Map<String, SCMSourceCategory> collectAndSimplify(@NonNull Iterable<SCMNavigator> navigators) {
        return SCMSourceCategory.simplify(SCMSourceCategory.addUncategorizedIfMissing(SCMSourceCategory.collect(navigators)));
    }

    public SCMSourceCategory(@CheckForNull Localizable pronoun) {
        super(pronoun);
    }

    public SCMSourceCategory(@NonNull String urlName, @CheckForNull Localizable pronoun) {
        super(urlName, pronoun);
    }

    @Override
    @NonNull
    protected Localizable defaultDisplayName() {
        return Messages._SCMSourceCategory_DisplayName();
    }
}

