/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Descriptor;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import jenkins.scm.api.Messages;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMSourceCategory;
import jenkins.scm.impl.UncategorizedSCMSourceCategory;
import net.jcip.annotations.GuardedBy;
import org.jenkins.ui.icon.IconSpec;

public abstract class SCMNavigatorDescriptor
extends Descriptor<SCMNavigator>
implements IconSpec {
    @GuardedBy(value="this")
    protected transient Set<SCMSourceCategory> categories;

    protected SCMNavigatorDescriptor() {
    }

    protected SCMNavigatorDescriptor(Class<? extends SCMNavigator> clazz) {
        super(clazz);
    }

    @NonNull
    public String getDescription() {
        return Messages.SCMNavigator_Description();
    }

    @NonNull
    public String getCategoryId() {
        return "nested-projects";
    }

    @CheckForNull
    public String getIconFilePathPattern() {
        return null;
    }

    @CheckForNull
    public String getIconClassName() {
        return null;
    }

    @CheckForNull
    public String getPronoun() {
        return null;
    }

    @NonNull
    public final synchronized Set<SCMSourceCategory> getCategories() {
        if (this.categories == null) {
            LinkedHashSet<SCMSourceCategory> categories = new LinkedHashSet<SCMSourceCategory>();
            boolean haveDefault = false;
            for (SCMSourceCategory c : this.createCategories()) {
                if (c.isUncategorized()) {
                    if (haveDefault) continue;
                    categories.add(c);
                    haveDefault = true;
                    continue;
                }
                categories.add(c);
            }
            if (!haveDefault) {
                categories.add(UncategorizedSCMSourceCategory.DEFAULT);
            }
            this.categories = Collections.unmodifiableSet(categories);
        }
        return this.categories;
    }

    @GuardedBy(value="this")
    @NonNull
    protected SCMSourceCategory[] createCategories() {
        return new SCMSourceCategory[]{UncategorizedSCMSourceCategory.DEFAULT};
    }

    @CheckForNull
    public abstract SCMNavigator newInstance(@CheckForNull String var1);
}

