/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMEventListener;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMNavigator;

public abstract class SCMNavigatorEvent<P>
extends SCMEvent<P> {
    private static final Logger LOGGER = Logger.getLogger(SCMHeadEvent.class.getName());

    @Deprecated
    public SCMNavigatorEvent(@NonNull SCMEvent.Type type, long timestamp, @NonNull P payload) {
        super(type, timestamp, payload);
    }

    public SCMNavigatorEvent(@NonNull SCMEvent.Type type, long timestamp, @NonNull P payload, @CheckForNull String origin) {
        super(type, timestamp, payload, origin);
    }

    @Deprecated
    public SCMNavigatorEvent(@NonNull SCMEvent.Type type, @NonNull P payload) {
        super(type, payload);
    }

    public SCMNavigatorEvent(@NonNull SCMEvent.Type type, @NonNull P payload, @CheckForNull String origin) {
        super(type, payload, origin);
    }

    protected SCMNavigatorEvent(@NonNull SCMNavigatorEvent<P> src) {
        super(src);
    }

    public abstract boolean isMatch(SCMNavigator var1);

    public static void fireNow(@NonNull SCMNavigatorEvent<?> event) {
        SCMNavigatorEvent.executorService().execute(new DispatcherImpl(event));
    }

    public static void fireLater(@NonNull SCMNavigatorEvent<?> event, long delay, TimeUnit delayUnits) {
        SCMNavigatorEvent.executorService().schedule(new DispatcherImpl(event), delay, delayUnits);
    }

    private static class DispatcherImpl
    extends SCMEvent.Dispatcher<SCMNavigatorEvent<?>> {
        private DispatcherImpl(SCMNavigatorEvent<?> event) {
            super(event);
        }

        @Override
        protected void log(SCMEventListener l, Throwable e) {
            LogRecord lr = new LogRecord(Level.WARNING, "SCMEventListener.onSCMSourceEvent(SCMSourceEvent) {0} propagated an exception");
            lr.setThrown(e);
            lr.setParameters(new Object[]{l});
            LOGGER.log(lr);
        }

        @Override
        protected void fire(SCMEventListener l, SCMNavigatorEvent<?> event) {
            l.onSCMNavigatorEvent(event);
        }
    }
}

