/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMEventListener;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMSource;

public abstract class SCMSourceEvent<P>
extends SCMEvent<P> {
    private static final Logger LOGGER = Logger.getLogger(SCMSourceEvent.class.getName());

    @Deprecated
    public SCMSourceEvent(@NonNull SCMEvent.Type type, long timestamp, @NonNull P payload) {
        super(type, timestamp, payload);
    }

    public SCMSourceEvent(@NonNull SCMEvent.Type type, long timestamp, @NonNull P payload, @CheckForNull String origin) {
        super(type, timestamp, payload, origin);
    }

    @Deprecated
    public SCMSourceEvent(@NonNull SCMEvent.Type type, @NonNull P payload) {
        super(type, payload);
    }

    public SCMSourceEvent(@NonNull SCMEvent.Type type, @NonNull P payload, @CheckForNull String origin) {
        super(type, payload, origin);
    }

    protected SCMSourceEvent(@NonNull SCMSourceEvent<P> src) {
        super(src);
    }

    public abstract boolean isMatch(@NonNull SCMNavigator var1);

    public abstract boolean isMatch(@NonNull SCMSource var1);

    @NonNull
    public abstract String getSourceName();

    public static void fireNow(@NonNull SCMSourceEvent<?> event) {
        SCMSourceEvent.executorService().execute(new DispatcherImpl(event));
    }

    public static void fireLater(@NonNull SCMSourceEvent<?> event, long delay, TimeUnit delayUnits) {
        SCMSourceEvent.executorService().schedule(new DispatcherImpl(event), delay, delayUnits);
    }

    private static class DispatcherImpl
    extends SCMEvent.Dispatcher<SCMSourceEvent<?>> {
        private DispatcherImpl(SCMSourceEvent<?> event) {
            super(event);
        }

        @Override
        protected void log(SCMEventListener l, Throwable e) {
            LogRecord lr = new LogRecord(Level.WARNING, "SCMEventListener.onSCMSourceEvent(SCMSourceEvent) {0} propagated an exception");
            lr.setThrown(e);
            lr.setParameters(new Object[]{l});
            LOGGER.log(lr);
        }

        @Override
        protected void fire(SCMEventListener l, SCMSourceEvent<?> event) {
            l.onSCMSourceEvent(event);
        }
    }
}

