/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMNavigatorOwner;

public abstract class SCMNavigatorOwners
implements ExtensionPoint,
Iterable<SCMNavigatorOwner> {
    @NonNull
    public static Iterable<SCMNavigatorOwner> all() {
        return new All();
    }

    private static class All
    implements Iterable<SCMNavigatorOwner> {
        private All() {
        }

        @Override
        public Iterator<SCMNavigatorOwner> iterator() {
            return new IteratorImpl((Collection)ExtensionList.lookup(Enumerator.class));
        }

        private static class IteratorImpl
        implements Iterator<SCMNavigatorOwner> {
            private final Iterator<Enumerator> enumerators;
            private Iterator<SCMNavigatorOwner> owners;

            private IteratorImpl(Collection<Enumerator> enumerators) {
                this.enumerators = enumerators.iterator();
            }

            @Override
            public boolean hasNext() {
                while (true) {
                    if (this.owners != null && this.owners.hasNext()) {
                        return true;
                    }
                    if (!this.enumerators.hasNext()) break;
                    this.owners = this.enumerators.next().iterator();
                }
                return false;
            }

            @Override
            public SCMNavigatorOwner next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.owners.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Extension
    public static class JenkinsItemEnumerator
    extends Enumerator {
        @Override
        public Iterator<SCMNavigatorOwner> iterator() {
            Jenkins j = Jenkins.getActiveInstance();
            return j.getAllItems(SCMNavigatorOwner.class).iterator();
        }
    }

    public static abstract class Enumerator
    implements ExtensionPoint,
    Iterable<SCMNavigatorOwner> {
    }
}

