/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Action;
import hudson.model.Item;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.TransientActionFactory;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class SCMHead
implements Comparable<SCMHead>,
Serializable {
    private static final Logger LOGGER = Logger.getLogger(SCMHead.class.getName());
    private static final long serialVersionUID = 1L;
    @NonNull
    private final String name;

    public SCMHead(@NonNull String name) {
        name.getClass();
        this.name = name;
    }

    @Exported
    @NonNull
    public String getName() {
        return this.name;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SCMHead scmHead = (SCMHead)o;
        return this.name.equals(scmHead.name);
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(SCMHead o) {
        return this.getName().compareTo(o.getName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SCMHead{'");
        sb.append(this.name).append("'}");
        return sb.toString();
    }

    @Exported(name="actions")
    @NonNull
    public List<? extends Action> getAllActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        for (TransientActionFactory taf : ExtensionList.lookup(TransientActionFactory.class)) {
            if (!taf.type().isInstance(this)) continue;
            try {
                actions.addAll(this.createFor(taf));
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Could not load actions from " + taf + " for " + this, e);
            }
        }
        return Collections.unmodifiableList(actions);
    }

    private <T> Collection<? extends Action> createFor(TransientActionFactory<T> taf) {
        return taf.createFor(taf.type().cast(this));
    }

    @CheckForNull
    public <T extends Action> T getAction(@NonNull Class<T> type) {
        for (Action action : this.getAllActions()) {
            if (!type.isInstance(action)) continue;
            return (T)((Action)type.cast(action));
        }
        return null;
    }

    public static abstract class HeadByItem
    implements ExtensionPoint {
        @CheckForNull
        public abstract SCMHead getHead(Item var1);

        @CheckForNull
        public static SCMHead findHead(Item item) {
            for (HeadByItem ext : ExtensionList.lookup(HeadByItem.class)) {
                SCMHead head = ext.getHead(item);
                if (head == null) continue;
                return head;
            }
            return null;
        }
    }
}

