/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.annotation.CheckForNull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.WebApp;

public abstract class SCMFile {
    @NonNull
    public abstract String getName();

    @CheckForNull
    public abstract SCMFile get(String var1) throws IOException;

    @NonNull
    public abstract Iterable<SCMFile> children() throws IOException;

    public abstract boolean isFile() throws IOException;

    public boolean isDirectory() throws IOException {
        return !this.isFile();
    }

    @NonNull
    public abstract InputStream content() throws IOException;

    @NonNull
    public byte[] contentAsBytes() throws IOException {
        InputStream is = this.content();
        try {
            byte[] byArray = IOUtils.toByteArray((InputStream)is);
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    @NonNull
    public String contentAsString() throws IOException {
        InputStream is = this.content();
        try {
            String string = IOUtils.toString((InputStream)is, (Charset)this.contentEncoding());
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    @NonNull
    public String contentMimeType() throws IOException {
        return this.getMimeType(this.getName());
    }

    public boolean isContentBinary() throws IOException {
        return !this.isContentText();
    }

    public boolean isContentText() throws IOException {
        return StringUtils.startsWithIgnoreCase((String)this.contentMimeType(), (String)"text/");
    }

    @NonNull
    public Charset contentEncoding() throws IOException {
        return Charset.defaultCharset();
    }

    @NonNull
    private String getMimeType(@NonNull String fileName) {
        int idx = fileName.lastIndexOf(47);
        fileName = fileName.substring(idx + 1);
        idx = fileName.lastIndexOf(92);
        fileName = fileName.substring(idx + 1);
        WebApp webApp = WebApp.getCurrent();
        String extension = fileName.substring(fileName.lastIndexOf(46) + 1);
        String mimeType = (String)webApp.mimeTypes.get(extension);
        if (mimeType == null) {
            mimeType = webApp.context.getMimeType(fileName);
        }
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        if (webApp.defaultEncodingForStaticResources.containsKey(mimeType)) {
            mimeType = mimeType + ";charset=" + (String)webApp.defaultEncodingForStaticResources.get(mimeType);
        }
        return mimeType;
    }
}

