/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionPoint;
import hudson.model.AbstractDescribableImpl;
import hudson.model.TaskListener;
import hudson.scm.SCM;
import hudson.util.LogTaskListener;
import java.io.IOException;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceOwner;
import net.jcip.annotations.GuardedBy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SCMSource
extends AbstractDescribableImpl<SCMSource>
implements ExtensionPoint {
    @GuardedBy(value="this")
    @CheckForNull
    private String id;
    @GuardedBy(value="this")
    @CheckForNull
    private transient SCMSourceOwner owner;

    protected SCMSource(@CheckForNull String id) {
        this.id = id == null ? UUID.randomUUID().toString() : id;
    }

    @NonNull
    public final synchronized String getId() {
        if (this.id == null) {
            this.id = UUID.randomUUID().toString();
        }
        return this.id;
    }

    public final synchronized void setOwner(@CheckForNull SCMSourceOwner owner) {
        this.owner = owner;
    }

    @CheckForNull
    public final synchronized SCMSourceOwner getOwner() {
        return this.owner;
    }

    @CheckForNull
    protected final SCMSourceCriteria getCriteria() {
        SCMSourceOwner owner = this.getOwner();
        if (owner == null) {
            return null;
        }
        return owner.getSCMSourceCriteria(this);
    }

    @NonNull
    public final <O extends SCMHeadObserver> O fetch(@NonNull O observer, @CheckForNull TaskListener listener) throws IOException, InterruptedException {
        this.retrieve(observer, this.defaultListener(listener));
        return observer;
    }

    @NonNull
    protected abstract void retrieve(@NonNull SCMHeadObserver var1, @NonNull TaskListener var2) throws IOException, InterruptedException;

    @NonNull
    public final Set<SCMHead> fetch(@CheckForNull TaskListener listener) throws IOException, InterruptedException {
        return this.retrieve(this.defaultListener(listener));
    }

    @NonNull
    protected Set<SCMHead> retrieve(@NonNull TaskListener listener) throws IOException, InterruptedException {
        return this.fetch(SCMHeadObserver.collect(), listener).result().keySet();
    }

    @CheckForNull
    public final SCMRevision fetch(@NonNull SCMHead head, @CheckForNull TaskListener listener) throws IOException, InterruptedException {
        return this.retrieve(head, this.defaultListener(listener));
    }

    @CheckForNull
    protected SCMRevision retrieve(@NonNull SCMHead head, @NonNull TaskListener listener) throws IOException, InterruptedException {
        return this.fetch(SCMHeadObserver.select(head), listener).result();
    }

    @NonNull
    public abstract SCM build(@NonNull SCMHead var1, @CheckForNull SCMRevision var2);

    @NonNull
    public final SCM build(@NonNull SCMHead head) {
        return this.build(head, null);
    }

    @NonNull
    protected final TaskListener defaultListener(@CheckForNull TaskListener listener) {
        if (listener == null) {
            Level level;
            try {
                level = Level.parse(System.getProperty(((Object)((Object)this)).getClass().getName() + ".defaultListenerLevel", "FINE"));
            }
            catch (IllegalArgumentException e) {
                level = Level.FINE;
            }
            return new LogTaskListener(Logger.getLogger(((Object)((Object)this)).getClass().getName()), level);
        }
        return listener;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SCMSource)) {
            return false;
        }
        SCMSource that = (SCMSource)((Object)o);
        return this.getId().equals(that.getId());
    }

    public final int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(((Object)((Object)this)).getClass().getName());
        sb.append("{id='").append(this.id).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

