/*
 * Decompiled with CFR 0.152.
 */
package com.waytta;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.google.common.collect.ImmutableSet;
import com.waytta.Builds;
import com.waytta.SaltAPIBuilder;
import com.waytta.SaltException;
import com.waytta.ServerToken;
import com.waytta.Utils;
import com.waytta.clientinterface.BasicClient;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class SaltAPIStep
extends Step
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger("com.waytta.saltstack");
    private String servername;
    private String authtype;
    private BasicClient clientInterface;
    private boolean saveEnvVar = false;
    private final String credentialsId;
    private boolean saveFile = false;
    private static String token = null;
    private static String netapi = null;
    private static JSONObject saltFunc = null;
    private boolean skipValidation = false;

    @DataBoundConstructor
    public SaltAPIStep(String servername, String authtype, BasicClient clientInterface, String credentialsId) {
        this.servername = servername;
        this.authtype = authtype;
        this.clientInterface = clientInterface;
        this.credentialsId = credentialsId;
    }

    public String getServername() {
        return this.servername;
    }

    public String getAuthtype() {
        return this.authtype;
    }

    public String getTarget() {
        return this.clientInterface.getTarget();
    }

    public String getTargettype() {
        return this.clientInterface.getTargettype();
    }

    public String getFunction() {
        return this.clientInterface.getFunction();
    }

    public String getArguments() {
        return this.clientInterface.getArguments();
    }

    public boolean getBlockbuild() {
        return this.clientInterface.getBlockbuild();
    }

    public String getBatchSize() {
        return this.clientInterface.getBatchSize();
    }

    public int getJobPollTime() {
        return this.clientInterface.getJobPollTime();
    }

    public int getMinionTimeout() {
        return this.clientInterface.getMinionTimeout();
    }

    public String getMods() {
        return this.clientInterface.getMods();
    }

    public String getPillarvalue() {
        return this.clientInterface.getPillarvalue();
    }

    public String getSubset() {
        return this.clientInterface.getSubset();
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setSaveEnvVar(boolean saveEnvVar) {
        this.saveEnvVar = saveEnvVar;
    }

    public boolean getSaveEnvVar() {
        return this.saveEnvVar;
    }

    @DataBoundSetter
    public void setSaveFile(boolean saveFile) {
        this.saveFile = saveFile;
    }

    public boolean getSaveFile() {
        return this.saveFile;
    }

    public BasicClient getClientInterface() {
        return this.clientInterface;
    }

    public String getPost() {
        return this.clientInterface.getPost();
    }

    public String getTag() {
        return this.clientInterface.getTag();
    }

    @DataBoundSetter
    public void setSkipValidation(boolean skipValidation) {
        this.skipValidation = skipValidation;
    }

    public boolean getSkipValidation() {
        return this.skipValidation;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public class Execution
    extends AbstractStepExecutionImpl {
        private static final long serialVersionUID = 1L;
        private String jid;
        @Inject
        private SaltAPIStep saltStep;
        private volatile transient ScheduledFuture<?> task;
        SaltAPIBuilder saltBuilder;

        Execution(SaltAPIStep step, StepContext context) {
            super(context);
            this.saltStep = step;
        }

        public void stop(Throwable cause) throws Exception {
            if (this.task != null) {
                this.task.cancel(false);
            }
            this.getContext().onFailure(cause);
        }

        public boolean start() throws Exception {
            Launcher launcher = (Launcher)this.getContext().get(Launcher.class);
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            this.prepareRun();
            this.jid = this.saltBuilder.getJID(launcher, this.saltBuilder.getServername(), token, saltFunc, listener);
            new Thread("saltAPI"){

                @Override
                public void run() {
                    try {
                        Execution.this.saltPerform(token, saltFunc, netapi);
                    }
                    catch (Exception e) {
                        Execution.this.getContext().onFailure((Throwable)e);
                    }
                }
            }.start();
            return false;
        }

        public void onResume() {
            TaskListener listener = null;
            Launcher launcher = null;
            FilePath workspace = null;
            try {
                listener = (TaskListener)this.getContext().get(TaskListener.class);
                launcher = (Launcher)this.getContext().get(Launcher.class);
                workspace = (FilePath)this.getContext().get(FilePath.class);
            }
            catch (Exception e) {
                this.getContext().onFailure((Throwable)e);
            }
            if (this.jid == null || this.jid.equals("")) {
                throw new RuntimeException("Unable to resume. Missing JID.");
            }
            listener.getLogger().println("Resuming jid: " + this.jid);
            try {
                this.prepareRun();
            }
            catch (Exception e) {
                this.getContext().onFailure((Throwable)e);
            }
            int jobPollTime = this.saltBuilder.getJobPollTime();
            int minionTimeout = this.saltBuilder.getMinionTimeout();
            JSONArray returnArray = null;
            try {
                returnArray = Builds.checkBlockingBuild(launcher, this.saltBuilder.getServername(), token, saltFunc, listener, jobPollTime, minionTimeout, netapi, this.jid);
            }
            catch (Exception e) {
                this.getContext().onFailure((Throwable)e);
            }
            this.postRun(returnArray);
        }

        private void prepareRun() throws InterruptedException, IOException {
            Run run = (Run)this.getContext().get(Run.class);
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            Launcher launcher = (Launcher)this.getContext().get(Launcher.class);
            this.saltBuilder = new SaltAPIBuilder(this.saltStep.servername, this.saltStep.authtype, this.saltStep.clientInterface, this.saltStep.credentialsId);
            StandardUsernamePasswordCredentials credential = (StandardUsernamePasswordCredentials)CredentialsProvider.findCredentialById((String)this.saltBuilder.getCredentialsId(), StandardUsernamePasswordCredentials.class, (Run)run, (DomainRequirement[])new DomainRequirement[0]);
            if (credential == null) {
                throw new RuntimeException("Invalid credentials");
            }
            JSONObject auth = Utils.createAuthArray(credential, this.saltBuilder.getAuthtype());
            ServerToken serverToken = Utils.getToken(launcher, this.saltBuilder.getServername(), auth);
            token = serverToken.getToken();
            netapi = serverToken.getServer();
            LOGGER.log(Level.FINE, "Discovered netapi: " + netapi);
            saltFunc = this.saltBuilder.prepareSaltFunction(run, listener, this.saltBuilder.getClientInterface().getDescriptor().getDisplayName(), this.saltBuilder.getTarget(), this.saltBuilder.getFunction(), this.saltBuilder.getArguments());
            LOGGER.log(Level.FINE, "Sending JSON: " + saltFunc.toString());
        }

        private void saltPerform(String token, JSONObject saltFunc, String netapi) throws Exception, SaltException {
            Run run = (Run)this.getContext().get(Run.class);
            FilePath workspace = (FilePath)this.getContext().get(FilePath.class);
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            Launcher launcher = (Launcher)this.getContext().get(Launcher.class);
            JSONArray returnArray = null;
            returnArray = this.saltBuilder.performRequest(launcher, run, token, this.saltBuilder.getServername(), saltFunc, listener, netapi, this.jid);
            this.postRun(returnArray);
        }

        private void postRun(JSONArray returnArray) {
            TaskListener listener = null;
            FilePath workspace = null;
            try {
                listener = (TaskListener)this.getContext().get(TaskListener.class);
                workspace = (FilePath)this.getContext().get(FilePath.class);
            }
            catch (Exception e) {
                this.getContext().onFailure((Throwable)e);
            }
            LOGGER.log(Level.FINE, "Received response: " + returnArray);
            boolean validFunctionExecution = true;
            if (!SaltAPIStep.this.skipValidation) {
                validFunctionExecution = Utils.validateFunctionCall(returnArray);
            } else {
                LOGGER.log(Level.INFO, "Skipping validation of salt return");
            }
            if (!validFunctionExecution) {
                listener.error("One or more minion did not return code 0\n");
                this.getContext().onFailure((Throwable)new SaltException(returnArray.toString()));
            }
            if (this.saltStep.saveFile) {
                try {
                    Utils.writeFile(returnArray.toString(), workspace);
                }
                catch (Exception e) {
                    this.getContext().onFailure((Throwable)e);
                }
            }
            this.getContext().onSuccess((Object)returnArray.toString());
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "salt";
        }

        public String getDisplayName() {
            return "Send a message to Salt API";
        }

        public FormValidation doCheckServername(@QueryParameter String value) {
            return SaltAPIBuilder.DescriptorImpl.doCheckServername(value);
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Job context, @QueryParameter String credentialsId, @QueryParameter String servername) {
            return SaltAPIBuilder.DescriptorImpl.doFillCredentialsIdItems(context, credentialsId, servername);
        }

        public FormValidation doCheckCredentialsId(@AncestorInPath Item project, @QueryParameter String value) {
            return SaltAPIBuilder.DescriptorImpl.doCheckCredentialsId(project, value);
        }

        public FormValidation doTestConnection(@QueryParameter String servername, @QueryParameter String credentialsId, @QueryParameter String authtype, @AncestorInPath Item project) {
            return SaltAPIBuilder.DescriptorImpl.doTestConnection(servername, credentialsId, authtype, project);
        }

        public Set<Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, FilePath.class, TaskListener.class, Launcher.class);
        }
    }
}

