/*
 * Decompiled with CFR 0.152.
 */
package com.waytta;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.waytta.Builds;
import com.waytta.HttpCallable;
import com.waytta.PublishEnvVarAction;
import com.waytta.SaltException;
import com.waytta.ServerToken;
import com.waytta.Utils;
import com.waytta.clientinterface.BasicClient;
import com.waytta.clientinterface.LocalBatchClient;
import com.waytta.clientinterface.LocalClient;
import com.waytta.clientinterface.RunnerClient;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.queue.Tasks;
import hudson.remoting.Callable;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.acegisecurity.Authentication;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.yaml.snakeyaml.Yaml;

public class SaltAPIBuilder
extends Builder
implements SimpleBuildStep,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger("com.waytta.saltstack");
    private String servername;
    private String authtype;
    private BasicClient clientInterface;
    private boolean saveEnvVar = false;
    private final String credentialsId;
    private boolean saveFile = false;
    private boolean skipValidation = false;
    @Deprecated
    private transient JSONObject clientInterfaces;
    @Deprecated
    private transient String target;
    @Deprecated
    private transient String targettype;
    @Deprecated
    private transient String function;
    @Deprecated
    private transient String arguments;
    @Deprecated
    private transient String kwarguments;
    @Deprecated
    private transient String batchSize;
    @Deprecated
    private transient String mods;
    @Deprecated
    private transient String pillarvalue;
    @Deprecated
    private transient Boolean blockbuild;
    @Deprecated
    private transient Integer jobPollTime;
    @Deprecated
    private transient Boolean usePillar;
    @Deprecated
    private transient String pillarkey;

    protected Object readResolve() throws IOException {
        if (this.clientInterfaces != null) {
            this.arguments = this.arguments.replaceAll(",", " ");
            if (this.clientInterfaces.has("clientInterface")) {
                if (this.clientInterfaces.getString("clientInterface").equals("local")) {
                    this.clientInterface = new LocalClient(this.function, this.arguments + " " + this.kwarguments, this.target, this.targettype);
                    ((LocalClient)this.clientInterface).setJobPollTime(this.clientInterfaces.getInt("jobPollTime"));
                    ((LocalClient)this.clientInterface).setBlockbuild(this.clientInterfaces.getBoolean("blockbuild"));
                } else if (this.clientInterfaces.getString("clientInterface").equals("local_batch")) {
                    this.clientInterface = new LocalBatchClient(this.function, this.arguments + " " + this.kwarguments, this.batchSize, this.target, this.targettype);
                } else if (this.clientInterfaces.getString("clientInterface").equals("runner")) {
                    this.clientInterface = new RunnerClient(this.function, this.arguments + " " + this.kwarguments, this.mods, this.pillarvalue);
                }
            }
            this.clientInterfaces = null;
        }
        return this;
    }

    @DataBoundConstructor
    public SaltAPIBuilder(String servername, String authtype, BasicClient clientInterface, String credentialsId) {
        this.servername = servername;
        this.authtype = authtype;
        this.clientInterface = clientInterface;
        this.credentialsId = credentialsId;
    }

    public String getServername() {
        return this.servername;
    }

    @DataBoundSetter
    public void setServername(String servername) {
        this.servername = servername;
    }

    public String getAuthtype() {
        return this.authtype;
    }

    public String getTarget() {
        return this.clientInterface.getTarget();
    }

    public String getTargettype() {
        return this.clientInterface.getTargettype();
    }

    public String getFunction() {
        return this.clientInterface.getFunction();
    }

    public String getArguments() {
        return this.clientInterface.getArguments();
    }

    public boolean getBlockbuild() {
        return this.clientInterface.getBlockbuild();
    }

    public String getBatchSize() {
        return this.clientInterface.getBatchSize();
    }

    public int getJobPollTime() {
        return this.clientInterface.getJobPollTime();
    }

    public int getMinionTimeout() {
        return this.clientInterface.getMinionTimeout();
    }

    public String getMods() {
        return this.clientInterface.getMods();
    }

    public String getPillarvalue() {
        return this.clientInterface.getPillarvalue();
    }

    public String getSubset() {
        return this.clientInterface.getSubset();
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setSaveEnvVar(boolean saveEnvVar) {
        this.saveEnvVar = saveEnvVar;
    }

    public boolean getSaveEnvVar() {
        return this.saveEnvVar;
    }

    @DataBoundSetter
    public void setSaveFile(boolean saveFile) {
        this.saveFile = saveFile;
    }

    public boolean getSaveFile() {
        return this.saveFile;
    }

    public BasicClient getClientInterface() {
        return this.clientInterface;
    }

    public String getPost() {
        return this.clientInterface.getPost();
    }

    public String getTag() {
        return this.clientInterface.getTag();
    }

    @DataBoundSetter
    public void setSkipValidation(boolean skipValidation) {
        this.skipValidation = skipValidation;
    }

    public boolean getSkipValidation() {
        return this.skipValidation;
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        JSONArray returnArray;
        String myOutputFormat = this.getDescriptor().getOutputFormat();
        String myClientInterface = this.clientInterface.getDescriptor().getDisplayName();
        String myservername = Utils.paramorize(build, listener, this.servername);
        String mytarget = Utils.paramorize(build, listener, this.getTarget());
        String myfunction = Utils.paramorize(build, listener, this.getFunction());
        String myarguments = Utils.paramorize(build, listener, this.getArguments());
        boolean jobSuccess = true;
        StandardUsernamePasswordCredentials credential = (StandardUsernamePasswordCredentials)CredentialsProvider.findCredentialById((String)this.getCredentialsId(), StandardUsernamePasswordCredentials.class, build, (DomainRequirement[])new DomainRequirement[0]);
        if (credential == null) {
            listener.error("Invalid credentials");
            throw new RuntimeException("Invalid credentials");
        }
        JSONObject auth = Utils.createAuthArray(credential, this.authtype);
        ServerToken serverToken = Utils.getToken(launcher, myservername, auth);
        String token = serverToken.getToken();
        String netapi = serverToken.getServer();
        LOGGER.log(Level.FINE, "Discovered netapi: " + netapi);
        JSONObject saltFunc = this.prepareSaltFunction(build, listener, myClientInterface, mytarget, myfunction, myarguments);
        LOGGER.log(Level.FINE, "Sending JSON: " + saltFunc.toString());
        try {
            String jid = this.getJID(launcher, myservername, token, saltFunc, listener);
            returnArray = this.performRequest(launcher, build, token, myservername, saltFunc, listener, netapi, jid);
        }
        catch (SaltException e) {
            throw new RuntimeException(e);
        }
        LOGGER.log(Level.FINE, "Received response: " + returnArray);
        if (this.saveEnvVar) {
            build.addAction((Action)new PublishEnvVarAction("SALTBUILDOUTPUT", returnArray.toString()));
        }
        if (this.saveFile) {
            Utils.writeFile(returnArray.toString(), workspace);
        }
        boolean validFunctionExecution = true;
        if (!this.skipValidation) {
            validFunctionExecution = Utils.validateFunctionCall(returnArray);
        } else {
            LOGGER.log(Level.INFO, "Skipping validation of salt return");
        }
        if (!validFunctionExecution) {
            listener.error("One or more minion did not return code 0\n");
            jobSuccess = false;
        }
        if (myOutputFormat.equals("none")) {
            listener.getLogger().println("Completed " + myfunction + " " + myarguments);
            return;
        }
        if (myfunction.length() > 0) {
            listener.getLogger().print("Response on " + myfunction);
        }
        if (myarguments.length() > 0) {
            listener.getLogger().print(" " + myarguments);
        }
        if (mytarget.length() > 0) {
            listener.getLogger().print(" for " + mytarget + ":");
        }
        listener.getLogger().println("");
        if (myOutputFormat.equals("json")) {
            listener.getLogger().println(returnArray.toString(2));
        } else if (myOutputFormat.equals("yaml")) {
            Object[] outputObject = returnArray.toArray();
            Yaml yaml = new Yaml();
            listener.getLogger().println(yaml.dump((Object)outputObject));
        } else {
            listener.error("Unknown output Format: x" + myOutputFormat + "x");
            throw new RuntimeException("Unknown output format");
        }
        if (!jobSuccess) {
            throw new RuntimeException("Salt failure detected");
        }
    }

    public String getJID(Launcher launcher, String serverName, String token, JSONObject saltFunc, TaskListener listener) throws IOException, InterruptedException, SaltException {
        if (saltFunc.has("client") && ((String)saltFunc.get("client")).contains("async")) {
            return Builds.getBlockingBuildJid(launcher, serverName, token, saltFunc, listener);
        }
        return null;
    }

    public JSONArray performRequest(Launcher launcher, Run build, String token, String serverName, JSONObject saltFunc, TaskListener listener, String netapi, String jid) throws InterruptedException, IOException, SaltException {
        JSONArray returnArray = new JSONArray();
        JSONObject httpResponse = new JSONObject();
        if (!saltFunc.has("client")) {
            String myTag = Utils.paramorize(build, listener, this.getTag());
            myTag = myTag.replaceAll("^/", "");
            myTag = URLEncoder.encode(myTag, "UTF-8");
            httpResponse = (JSONObject)JSONSerializer.toJSON((Object)launcher.getChannel().call((Callable)new HttpCallable(serverName + "/hook/" + myTag, saltFunc, token)));
            returnArray.add((Object)httpResponse);
        } else if (saltFunc.get("client").equals("local_async")) {
            int jobPollTime = this.getJobPollTime();
            int minionTimeout = this.getMinionTimeout();
            returnArray = Builds.checkBlockingBuild(launcher, serverName, token, saltFunc, listener, jobPollTime, minionTimeout, netapi, jid);
        } else {
            httpResponse = (JSONObject)JSONSerializer.toJSON((Object)launcher.getChannel().call((Callable)new HttpCallable(serverName, saltFunc, token)));
            returnArray = httpResponse.getJSONArray("return");
        }
        return returnArray;
    }

    public JSONObject prepareSaltFunction(Run build, TaskListener listener, String myClientInterface, String mytarget, String myfunction, String myarguments) throws IOException, InterruptedException {
        JSONObject saltFunc = new JSONObject();
        saltFunc.put("client", (Object)myClientInterface);
        switch (myClientInterface) {
            case "local": {
                saltFunc.put("tgt", (Object)mytarget);
                saltFunc.put("expr_form", (Object)this.getTargettype());
                if (!this.getBlockbuild()) break;
                saltFunc.element("client", (Object)"local_async");
                break;
            }
            case "local_batch": {
                saltFunc.put("tgt", (Object)mytarget);
                saltFunc.put("expr_form", (Object)this.getTargettype());
                String mybatch = Utils.paramorize(build, listener, this.getBatchSize());
                saltFunc.put("batch", (Object)mybatch);
                listener.getLogger().println("Running in batch mode. Batch size: " + mybatch);
                break;
            }
            case "runner": {
                String myPillarvalue;
                String myMods = this.getMods();
                if (myMods != null && !myMods.trim().isEmpty()) {
                    saltFunc.put("mods", (Object)myMods);
                }
                if ((myPillarvalue = Utils.paramorize(build, listener, this.getPillarvalue())).length() <= 0) break;
                JSON runPillarValue = JSONSerializer.toJSON((Object)myPillarvalue);
                saltFunc.put("pillar", (Object)runPillarValue);
                break;
            }
            case "local_subset": {
                saltFunc.put("tgt", (Object)mytarget);
                saltFunc.put("expr_form", (Object)this.getTargettype());
                String mySubset = Utils.paramorize(build, listener, this.getSubset());
                saltFunc.put("sub", (Object)Integer.parseInt(mySubset));
                listener.getLogger().println("Running in subset mode. Subset size: " + mySubset);
                break;
            }
            case "hook": {
                String myPost = Utils.paramorize(build, listener, this.getPost());
                saltFunc = myPost.length() == 0 ? JSONObject.fromObject((Object)"{}") : JSONObject.fromObject((Object)myPost);
                return saltFunc;
            }
        }
        saltFunc.put("fun", (Object)myfunction);
        if (myarguments != null) {
            Builds.addArgumentsToSaltFunction(myarguments, saltFunc);
        }
        return saltFunc;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        int pollTime = 10;
        int minionTimeout = 30;
        String outputFormat = "json";

        public DescriptorImpl() {
            this.load();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            try {
                this.pollTime = formData.getInt("pollTime");
                this.minionTimeout = formData.getInt("minionTimeout");
            }
            catch (Exception e) {
                this.pollTime = 10;
                this.minionTimeout = 30;
            }
            this.outputFormat = formData.getString("outputFormat");
            this.save();
            return super.configure(req, formData);
        }

        public int getPollTime() {
            return this.pollTime;
        }

        public int getMinionTimeout() {
            return this.minionTimeout;
        }

        public String getOutputFormat() {
            return this.outputFormat;
        }

        public static FormValidation doTestConnection(@QueryParameter String servername, @QueryParameter String credentialsId, @QueryParameter String authtype, @AncestorInPath Item project) {
            StandardUsernamePasswordCredentials usedCredential = null;
            for (StandardUsernamePasswordCredentials c : CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)project, null, Collections.emptyList())) {
                if (!c.getId().equals(credentialsId)) continue;
                usedCredential = c;
                break;
            }
            if (usedCredential == null) {
                return FormValidation.error((String)"CredentialId error: no credential found with given ID.");
            }
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins == null) {
                throw new IllegalStateException("Jenkins has not been started, or was already shut down");
            }
            Launcher launcher = jenkins.createLauncher(TaskListener.NULL);
            if (!servername.matches("\\{\\{\\w+\\}\\}")) {
                JSONObject auth = Utils.createAuthArray(usedCredential, authtype);
                try {
                    String token = Utils.getToken(launcher, servername, auth).getToken();
                    if (token.contains("Error")) {
                        return FormValidation.error((String)("Client error: " + token));
                    }
                }
                catch (IOException | InterruptedException e) {
                    return FormValidation.error((String)"Error: Exception running http request");
                }
                return FormValidation.ok((String)"Success");
            }
            return FormValidation.warning((String)"Cannot expand parametrized server name.");
        }

        public static ListBoxModel doFillCredentialsIdItems(@AncestorInPath Job context, @QueryParameter String credentialsId, @QueryParameter String servername) {
            Item item = (Item)Stapler.getCurrentRequest().findAncestorObject(Item.class);
            return new StandardUsernameListBoxModel().includeAs(item instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)item)) : ACL.SYSTEM, item, StandardUsernamePasswordCredentials.class, Collections.emptyList());
        }

        public static FormValidation doCheckServername(@QueryParameter String value) {
            if (!value.matches("\\{\\{\\w+\\}\\}")) {
                if (value.length() == 0) {
                    return FormValidation.error((String)"Please specify a name");
                }
                if (value.length() < 10) {
                    return FormValidation.warning((String)"Isn't the name too short?");
                }
                if (!value.contains("https://") && !value.contains("http://")) {
                    return FormValidation.warning((String)"Missing protocol: Servername should be in the format https://host.domain:8000");
                }
                if (!value.substring(7).contains(":")) {
                    return FormValidation.warning((String)"Missing port: Servername should be in the format https://host.domain:8000");
                }
                return FormValidation.ok();
            }
            return FormValidation.warning((String)"Cannot expand parametrized server name.");
        }

        public static FormValidation doCheckCredentialsId(@AncestorInPath Item project, @QueryParameter String value) {
            if (project == null || !project.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (value == null) {
                return FormValidation.ok();
            }
            Item item = (Item)Stapler.getCurrentRequest().findAncestorObject(Item.class);
            for (ListBoxModel.Option o : CredentialsProvider.listCredentials(StandardUsernamePasswordCredentials.class, (Item)project, (Authentication)(item instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)item)) : ACL.SYSTEM), Collections.emptyList(), (CredentialsMatcher)CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class))) {
                if (!value.equals(o.value)) continue;
                return FormValidation.ok();
            }
            return FormValidation.error((String)("Cannot find any credentials with id " + value));
        }

        public FormValidation doCheckPollTime(@QueryParameter String value) {
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"Specify a number larger than 3");
            }
            if (Integer.parseInt(value) < 3) {
                return FormValidation.warning((String)"Specify a number larger than 3");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckMinionTimeout(@QueryParameter String value) {
            String errorText = "Specify a non zero number. Positive numbers fail the build when reached, negative numbers will timeout minions without failing";
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)errorText);
            }
            if (Integer.parseInt(value) == 0) {
                return FormValidation.warning((String)errorText);
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Send a message to Salt API";
        }
    }
}

