/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.reverse_proxy_auth.auth;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.security.SecurityRealm;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.jenkinsci.plugins.reverse_proxy_auth.auth.DefaultReverseProxyAuthoritiesPopulator;
import org.jenkinsci.plugins.reverse_proxy_auth.model.ReverseProxyUserDetails;

public final class ReverseProxyAuthoritiesPopulatorImpl
extends DefaultReverseProxyAuthoritiesPopulator {
    String rolePrefix = "ROLE_";
    boolean convertToUpperCase = true;

    public ReverseProxyAuthoritiesPopulatorImpl(@CheckForNull Hashtable<String, GrantedAuthority[]> authContext) {
        super(authContext);
        super.setRolePrefix("");
        super.setConvertToUpperCase(false);
    }

    @Override
    protected Set<GrantedAuthority> getAdditionalRoles(ReverseProxyUserDetails proxyUser) {
        return Collections.singleton(SecurityRealm.AUTHENTICATED_AUTHORITY);
    }

    @Override
    public void setRolePrefix(String rolePrefix) {
        this.rolePrefix = rolePrefix;
    }

    @Override
    public void setConvertToUpperCase(boolean convertToUpperCase) {
        this.convertToUpperCase = convertToUpperCase;
    }

    @Override
    public Set<GrantedAuthority> getGroupMembershipRoles(String username) {
        Set<GrantedAuthority> names = super.getGroupMembershipRoles(username);
        HashSet<GrantedAuthority> groupRoles = new HashSet<GrantedAuthority>(names.size() * 2);
        groupRoles.addAll(names);
        for (GrantedAuthority ga : names) {
            String role = ga.getAuthority();
            if (this.convertToUpperCase) {
                role = role.toUpperCase();
            }
            groupRoles.add((GrantedAuthority)new GrantedAuthorityImpl(this.rolePrefix + role));
        }
        return groupRoles;
    }
}

